/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UIUserListPortlet.gtmpl")
public class UIUserListPortlet
extends UIPortletApplication {
    private UIPageIterator iterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, null);

    public UIUserListPortlet() throws Exception {
        this.addChild((UIComponent)this.iterator_);
        this.init();
    }

    public void init() throws Exception {
        int n = this.iterator_.getCurrentPage();
        String spaceName = this.getSpaceName();
        String groupId = "/spaces/" + spaceName;
        OrganizationService orgSrc = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        PageList usersPageList = orgSrc.getUserHandler().findUsersByGroup(groupId);
        List users = usersPageList.getAll();
        ObjectPageList pageList = new ObjectPageList(users, 3);
        this.iterator_.setPageList((PageList)pageList);
        if (n <= pageList.getAvailablePage()) {
            this.iterator_.setCurrentPage(n);
        }
    }

    public UIPageIterator getUIPageIterator() throws Exception {
        return this.iterator_;
    }

    private String getSpaceName() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        HttpServletRequest request = pcontext.getRequest();
        String url = request.getRequestURL().toString();
        String[] tempSplit = url.split("/");
        String spaceName = tempSplit[tempSplit.length - 2];
        return spaceName;
    }

    public List<User> getUsersInSpace() throws Exception {
        this.init();
        return this.iterator_.getCurrentPageData();
    }

    public String getMemberships(String userName) throws Exception {
        String memberShip = null;
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = orgService.getMembershipHandler();
        Collection memberShips = memberShipHandler.findMembershipsByUserAndGroup(userName, "/spaces/" + this.getSpaceName());
        for (Membership aaa : memberShips) {
            if (memberShip == null) {
                memberShip = aaa.getMembershipType();
                continue;
            }
            memberShip = memberShip + "," + aaa.getMembershipType();
        }
        return memberShip;
    }
}

