/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.Collections;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import social.portal.webui.component.space.UISpaceMenuPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UISpaceMenuPortlet.gtmpl")
public class UISpaceMenuPortlet
extends UIPortletApplication {
    private SpaceService spaceService = null;
    private UIPortal uiPortal = Util.getUIPortal();

    public List<PageNode> getApps() throws Exception {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = spaceSrc.getSpaceByUrl(spaceUrl);
        UserPortalConfigService dataService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        PageNavigation pageNav = dataService.getPageNavigation("group", space.getGroupId());
        PageNode homeNode = pageNav.getNode(spaceUrl);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List list = homeNode.getChildren();
        PageNode pageNode = null;
        StringBuffer sb = new StringBuffer("SpaceSettingPortlet");
        String spaceSettingAppName = sb.insert(0, SpaceUtils.getSpaceUrl()).toString();
        for (PageNode node : list) {
            if (!node.getName().equals(spaceSettingAppName)) continue;
            pageNode = node;
            break;
        }
        if (pageNode != null) {
            list.remove(pageNode);
        }
        Collections.sort(list, new ApplicationComparator(this, null));
        if (spaceSrc.hasEditPermission(space, userId) && pageNode != null) {
            list.add(pageNode);
        }
        return list;
    }

    public String getSpaceName() throws Exception {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = spaceSrc.getSpaceByUrl(spaceUrl);
        return space.getName();
    }

    public String getAppSelected() throws Exception {
        PageNode selectedNode = this.uiPortal.getSelectedNode();
        String[] split = selectedNode.getUri().split("/");
        return split[split.length - 1];
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceByUrl(SpaceUtils.getSpaceUrl());
        SpaceAttachment spaceAtt = space.getSpaceAttachment();
        if (spaceAtt != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + spaceAtt.getWorkspace() + spaceAtt.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }
}

