/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.space.Space;
import org.exoplatform.webui.config.annotation.ComponentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app://groovy/portal/webui/component/UIDisplaySpaceActivities.gtmpl")
public class UIDisplaySpaceActivities
extends UIContainer {
    private Space space_;
    private IdentityManager identityManager_;
    private ActivityManager activityManager_;

    public void setSpace(Space space) {
        this.space_ = space;
    }

    public Space getSpace() {
        return this.space_;
    }

    public String getUserAvatarImageSource(String userIdentityId) throws Exception {
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getAvatarImageSource(PortalContainer.getInstance());
    }

    public String getUserFullName(String userIdentityId) throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getFullName();
    }

    public String getUserProfileUri(String userIdentityId) throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        return "/" + PortalContainer.getCurrentPortalContainerName() + "/private/classic/activities/" + userIdentity.getRemoteId();
    }

    public String toPrettyTime(long postedTime) {
        long time = (new Date().getTime() - postedTime) / 1000L;
        long value = 0L;
        if (time < 60L) {
            return "less than a minute ago";
        }
        if (time < 120L) {
            return "about a minute ago";
        }
        if (time < 3600L) {
            value = Math.round(time / 60L);
            return "about " + value + " minutes ago";
        }
        if (time < 7200L) {
            return "about an hour ago";
        }
        if (time < 86400L) {
            value = Math.round(time / 3600L);
            return "about " + value + " hours ago";
        }
        if (time < 172800L) {
            return "about a day ago";
        }
        if (time < 2592000L) {
            value = Math.round(time / 86400L);
            return "about " + value + " days ago";
        }
        if (time < 5184000L) {
            return "about a month ago";
        }
        value = Math.round(time / 2592000L);
        return "about " + value + " months ago";
    }

    public List<Activity> getActivityList() throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity spaceIdentity = this.identityManager_.getOrCreateIdentity("space", this.space_.getId());
        this.activityManager_ = this.getActivityManager();
        List activityList = this.activityManager_.getActivities(spaceIdentity);
        Collections.reverse(activityList);
        return activityList;
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }
}

