/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import social.portal.webui.component.space.UISpaceMenuPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UISpaceMenuPortlet.gtmpl", events={@EventConfig(name="RenameSpaceAppName", listeners={RenameSpaceAppNameActionListener.class})})
public class UISpaceMenuPortlet
extends UIPortletApplication {
    private static final String NEW_SPACE_APPLICATION_NAME = "newSpaceAppName";
    private static final String INVALID_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.invalidAppName";
    private static final String SPACE_SETTING_PORTLET = "SpaceSettingPortlet";
    private SpaceService spaceService = null;
    private UIPortal uiPortal = Util.getUIPortal();
    private Space space = null;

    public List<PageNode> getApps() throws Exception {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        this.space = spaceSrc.getSpaceByUrl(spaceUrl);
        if (this.space == null) {
            return new ArrayList<PageNode>(0);
        }
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        PageNavigation pageNav = dataStorage.getPageNavigation("group", this.space.getGroupId());
        PageNode homeNode = SpaceUtils.getHomeNode((PageNavigation)pageNav, (String)this.space.getUrl());
        if (homeNode == null) {
            throw new Exception("homeNode is null!");
        }
        List list = homeNode.getNodes();
        PageNode pageNode = null;
        for (PageNode node : list) {
            if (!node.getName().equals(SPACE_SETTING_PORTLET)) continue;
            pageNode = node;
            break;
        }
        if (!this.isLeader() && pageNode != null) {
            list.remove(pageNode);
        }
        Collections.sort(list, new ApplicationComparator(this, null));
        return list;
    }

    public String getSpaceName() throws Exception {
        this.space = this.getSpace();
        if (this.space == null) {
            return null;
        }
        return this.space.getName();
    }

    public String getAppSelected() throws Exception {
        PageNode selectedNode = this.uiPortal.getSelectedNode();
        String[] split = selectedNode.getUri().split("/");
        return split[split.length - 1];
    }

    protected String getImageSource() throws Exception {
        Space space = this.getSpace();
        return space.getImageSource();
    }

    private boolean isLeader() throws SpaceException {
        this.spaceService = this.getSpaceService();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        Space space = this.getSpace();
        return this.spaceService.hasEditPermission(space.getId(), userId);
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private Space getSpace() {
        if (this.space == null) {
            try {
                this.spaceService = this.getSpaceService();
                String spaceUrl = SpaceUtils.getSpaceUrl();
                this.space = this.spaceService.getSpaceByUrl(spaceUrl);
            }
            catch (SpaceException e) {
                e.printStackTrace();
            }
        }
        return this.space;
    }

    private boolean isAppNameExisted(PageNavigation pageNav, String nodeName) throws Exception {
        PageNode homeNode = pageNav.getNode(SpaceUtils.getSpaceUrl());
        if (homeNode == null) {
            throw new Exception("homeNode is null!");
        }
        List nodes = homeNode.getChildren();
        for (PageNode node : pageNav.getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        for (PageNode node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAppName(String appName) {
        if (appName == null || appName.length() < 1) {
            return false;
        }
        if (Character.isDigit((appName = appName.trim()).charAt(0)) || appName.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < appName.length(); ++i) {
            char c = appName.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean access$100(UISpaceMenuPortlet x0, String x1) {
        return x0.isValidAppName(x1);
    }

    static /* synthetic */ boolean access$200(UISpaceMenuPortlet x0, PageNavigation x1, String x2) throws Exception {
        return x0.isAppNameExisted(x1, x2);
    }
}

