/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceListAccess;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.webui.UISpaceSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import social.portal.webui.component.UIManageInvitationSpaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIManageInvitationSpaces.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIManageInvitationSpaces
extends UIContainer {
    private static final String MSG_ERROR_ACCEPT_INVITATION = "UIManageInvitationSpaces.msg.error_accept_invitation";
    private static final String MSG_ERROR_DENY_INVITATION = "UIManageInvitationSpaces.msg.error_deny_invitation";
    private static final String SPACE_DELETED_INFO = "UIManageInvitationSpaces.msg.DeletedInfo";
    private static final String INVITATION_REVOKED_INFO = "UIManageInvitationSpaces.msg.RevokedInfo";
    public static final Integer LEADER = 1;
    public static final Integer MEMBER = 2;
    private UIPageIterator iterator;
    private final Integer SPACES_PER_PAGE = 4;
    private final String ITERATOR_ID = "UIIteratorInvitationSpaces";
    private SpaceService spaceService = null;
    private String userId = null;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManageInvitationSpaces() throws Exception {
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorInvitationSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public List<Space> getInvitationSpaces() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getInvitedSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<Space> getInvitedSpaces() throws Exception {
        List listSpace = this.getSpaceList();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getInvitedSpaceNames());
        return this.getDisplayInvitedSpace(listSpace, this.iterator);
    }

    public int getRole(String spaceId) throws SpaceException {
        String userId;
        SpaceService spaceService = this.getSpaceService();
        if (spaceService.hasEditPermission(spaceId, userId = this.getUserId())) {
            return LEADER;
        }
        return MEMBER;
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        SpaceAttachment spaceAtt = space.getSpaceAttachment();
        if (spaceAtt != null) {
            return "/" + this.getRestContext() + "/jcr/" + this.getRepository() + "/" + spaceAtt.getWorkspace() + spaceAtt.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private List<String> getInvitedSpaceNames() throws Exception {
        List invitedSpaces = this.getInvitationSpaces();
        ArrayList<String> invitedSpaceNames = new ArrayList<String>();
        for (Space space : invitedSpaces) {
            invitedSpaceNames.add(space.getName());
        }
        return invitedSpaceNames;
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private List<Space> getSpaceList() throws Exception {
        List spaceList = this.getSpaces();
        List allInvitationSpace = this.getInvitationSpaces();
        ArrayList<Space> invitedSpaces = new ArrayList<Space>();
        if (allInvitationSpace.size() == 0) {
            return allInvitationSpace;
        }
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space invitationSpace : allInvitationSpace) {
                    if (!space.getName().equals(invitationSpace.getName())) continue;
                    invitedSpaces.add(invitationSpace);
                    continue block0;
                }
            }
            return invitedSpaces;
        }
        return allInvitationSpace;
    }

    private List<Space> getDisplayInvitedSpace(List<Space> spaces, UIPageIterator pageIterator_) throws Exception {
        int currentPage = pageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces), this.SPACES_PER_PAGE.intValue());
        pageIterator_.setPageList((PageList)pageList);
        int pageCount = pageIterator_.getAvailablePage();
        if (pageCount >= currentPage) {
            pageIterator_.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            pageIterator_.setCurrentPage(currentPage - 1);
        }
        return pageIterator_.getCurrentPageData();
    }

    static /* synthetic */ SpaceService access$000(UIManageInvitationSpaces x0) {
        return x0.getSpaceService();
    }

    static /* synthetic */ String access$100(UIManageInvitationSpaces x0) {
        return x0.getUserId();
    }
}

