/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UISpaceToolBarPortlet.gtmpl")
public class UISpaceToolBarPortlet
extends UIPortletApplication {
    private static final String SPACE_SETTING_PORTLET = "SpaceSettingPortlet";
    private SpaceService spaceService = null;
    private String userId = null;

    private List<Space> getAllUserSpaces() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getAccessibleSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<PageNavigation> getSpaceNavigations() throws Exception {
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        SpaceService spaceSrv = this.getSpaceService();
        List spaces = spaceSrv.getAllSpaces();
        ArrayList<PageNavigation> navigations = new ArrayList<PageNavigation>();
        for (Space space : spaces) {
            PageNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
            ArrayList nodes = spaceNavigation.getNodes();
            Iterator itr = nodes.iterator();
            String spaceName = space.getName();
            while (itr.hasNext()) {
                PageNode spaceNode = (PageNode)itr.next();
                String nodeName = spaceNode.getName();
                if (nodeName.equals(spaceName)) continue;
                itr.remove();
            }
            navigations.add(PageNavigationUtils.filter((PageNavigation)spaceNavigation, (String)remoteUser));
        }
        return navigations;
    }

    public boolean isRender(PageNode spaceNode, PageNode applicationNode) throws SpaceException {
        Space space;
        SpaceService spaceSrv = this.getSpaceService();
        String remoteUser = this.getUserId();
        String spaceUrl = spaceNode.getUri();
        if (spaceUrl.contains("/")) {
            spaceUrl = spaceUrl.split("/")[0];
        }
        if (spaceSrv.hasEditPermission(space = spaceSrv.getSpaceByUrl(spaceUrl), remoteUser)) {
            return true;
        }
        String appName = applicationNode.getName();
        return !appName.contains(SPACE_SETTING_PORTLET);
    }

    public PageNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedNode();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }
}

