/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import social.portal.webui.component.UISpaceInfo;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/uiform/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private final String SPACE_PRIORITY = "priority";
    private final String PRIORITY_HIGH = "high";
    private final String PRIORITY_IMMEDIATE = "immediate";
    private final String PRIORITY_LOW = "low";
    private SpaceService spaceService = null;
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";

    public UISpaceInfo() throws Exception {
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput("id", "id", null).setRendered(false))).addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d]+[\\s]*)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null).addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        ArrayList<SelectItemOption> priorityList = new ArrayList<SelectItemOption>(3);
        SelectItemOption pHigh = new SelectItemOption("high", (Object)"1");
        SelectItemOption pImmediate = new SelectItemOption("immediate", (Object)"2");
        SelectItemOption pLow = new SelectItemOption("low", (Object)"3");
        priorityList.add(pHigh);
        priorityList.add(pImmediate);
        priorityList.add(pLow);
        UIFormSelectBox selectPriority = new UIFormSelectBox("priority", "priority", priorityList);
        this.addUIFormInput((UIFormInput)selectPriority);
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput("tag", "tag", null).setRendered(false)));
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean((Object)space);
        this.getUIStringInput("tag").setValue((Object)space.getTag());
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput("id").getValue();
        Space space = spaceService.getSpaceById(id);
        return space.getImageSource();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }
}

