/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UISpacesToolBarPortlet.gtmpl")
public class UISpacesToolBarPortlet
extends UIPortletApplication {
    private static final String SPACE_SETTING_PORTLET = "SpaceSettingPortlet";
    private SpaceService spaceService = null;
    private String userId = null;

    public List<PageNavigation> getSpaceNavigations() throws Exception {
        String remoteUser = this.getUserId();
        List spaces = this.getSpaceService().getAccessibleSpaces(remoteUser);
        UserPortalConfig userPortalConfig = Util.getUIPortalApplication().getUserPortalConfig();
        List allNavigations = userPortalConfig.getNavigations();
        ArrayList<PageNavigation> navigations = new ArrayList<PageNavigation>();
        for (PageNavigation navi : allNavigations) {
            navigations.add(navi);
        }
        Iterator navigationItr = navigations.iterator();
        while (navigationItr.hasNext()) {
            String ownerId = ((PageNavigation)navigationItr.next()).getOwnerId();
            if (ownerId.startsWith("/spaces")) {
                String[] navigationParts = ownerId.split("/");
                Space space = this.spaceService.getSpaceByUrl(navigationParts[2]);
                if (space == null) {
                    navigationItr.remove();
                }
                if (navigationParts[1].equals("spaces") || spaces.contains(space)) continue;
                navigationItr.remove();
                continue;
            }
            navigationItr.remove();
        }
        return navigations;
    }

    public boolean isRender(PageNode spaceNode, PageNode applicationNode) throws SpaceException {
        Space space;
        SpaceService spaceSrv = this.getSpaceService();
        String remoteUser = this.getUserId();
        String spaceUrl = spaceNode.getUri();
        if (spaceUrl.contains("/")) {
            spaceUrl = spaceUrl.split("/")[0];
        }
        if ((space = spaceSrv.getSpaceByUrl(spaceUrl)) == null) {
            return false;
        }
        if (spaceSrv.hasEditPermission(space, remoteUser)) {
            return true;
        }
        String appName = applicationNode.getName();
        return !appName.contains(SPACE_SETTING_PORTLET);
    }

    public PageNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedNode();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }
}

