/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import javax.portlet.PortletPreferences;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.organization.OrganizationUtils;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UISocialLogoPortlet.gtmpl")
public class UISocialLogoPortlet
extends UIPortletApplication {
    private Profile profile;
    private static IdentityManager im;

    public String getURL() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        String imageSource = null;
        try {
            imageSource = this.getImageSource();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imageSource == null) {
            return pref.getValue("url", "");
        }
        return imageSource;
    }

    public String getNavigationTitle() throws Exception {
        PageNavigation navigation = Util.getUIPortal().getSelectedNavigation();
        if (navigation.getOwnerType().equals("group")) {
            return OrganizationUtils.getGroupLabel((String)navigation.getOwnerId());
        }
        if (navigation.getOwnerType().equals("user")) {
            ConversationState state = ConversationState.getCurrent();
            User user = (User)state.getAttribute("UserProfile");
            return user.getFullName();
        }
        return "";
    }

    public Profile getProfile(boolean forceReload) throws Exception {
        if (forceReload || this.profile == null) {
            Identity id = this.getIdentity();
            this.profile = id.getProfile();
        }
        return this.profile;
    }

    protected String getImageSource() throws Exception {
        Profile p = this.getProfile(true);
        AvatarAttachment att = (AvatarAttachment)p.getProperty("avatar");
        if (att != null) {
            return "/" + this.getRestContext() + "/jcr/" + this.getRepository() + "/" + att.getWorkspace() + att.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private Identity getIdentity() throws Exception {
        if (im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return im.getOrCreateIdentity("organization", this.getCurrentProfileID());
    }

    private String getCurrentProfileID() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

