/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIUserActivityStreamPortlet.gtmpl")
public class UIUserActivityStreamPortlet
extends UIPortletApplication {
    private String ownerName;
    private String viewerName = Utils.getViewerRemoteId();
    private UIComposer uiComposer;
    private PopupContainer hiddenContainer;
    private boolean composerDisplayed = false;
    UIUserActivitiesDisplay uiUserActivitiesDisplay;

    public UIUserActivityStreamPortlet() throws Exception {
        this.ownerName = Utils.getOwnerRemoteId();
        this.hiddenContainer = (PopupContainer)this.addChild(PopupContainer.class, null, "HiddenContainer");
        this.uiComposer = (UIComposer)this.addChild(UIComposer.class, null, null);
        this.uiComposer.setPostContext(UIComposer.PostContext.USER);
        this.uiComposer.setOptionContainer((UIContainer)this.hiddenContainer);
        this.uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.addChild(UIUserActivitiesDisplay.class, null, "UIUserActivitiesDisplay");
        this.uiComposer.setActivityDisplay((UIContainer)this.uiUserActivitiesDisplay);
    }

    public boolean isComposerDisplayed() {
        return this.composerDisplayed;
    }

    public void refresh() throws Exception {
        this.viewerName = Utils.getViewerRemoteId();
        this.ownerName = Utils.getOwnerRemoteId();
        if (this.viewerName.equals(this.ownerName)) {
            this.uiComposer.isActivityStreamOwner(true);
            this.uiComposer.setRendered(true);
        } else {
            this.uiComposer.isActivityStreamOwner(false);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), Utils.getOwnerIdentity());
            if (relationship != null && relationship.getStatus() == Relationship.Type.CONFIRMED) {
                this.uiComposer.setRendered(true);
            } else {
                this.uiComposer.setRendered(false);
            }
        }
        this.uiUserActivitiesDisplay.setOwnerName(this.ownerName);
    }

    public final boolean isTitleDisplayed() {
        String activities = "/activities";
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.contains("/activities");
    }

    protected void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }
}

