/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.UnsupportedMethodException;
import org.exoplatform.social.client.api.common.RealtimeListAccess;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.model.RestLike;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.QueryParams;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.exoplatform.social.client.api.util.SocialJSONDecodingSupport;
import org.exoplatform.social.client.core.service.ActivitiesRealtimeListAccessV1Alpha3;
import org.exoplatform.social.client.core.service.ServiceBase;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class ActivityServiceImplV1Alpha3
extends ServiceBase<RestActivity, ActivityService<RestActivity>>
implements ActivityService<RestActivity> {
    private static final String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);

    @Override
    public RestActivity create(RestActivity newInstance) throws SocialClientLibException {
        String POST_ACTIVITY_REQUEST_URL = BASE_URL + "activity.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(POST_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH, newInstance);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, responseContent);
            return restActivity;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestActivity create(RestActivity newActivity, QueryParams queryParams) throws SocialClientLibException {
        String POST_ACTIVITY_REQUEST_URL = BASE_URL + "activity.json?" + queryParams.buildQuery();
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(POST_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH, newActivity);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, responseContent);
            return restActivity;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestActivity get(String uuid) throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + uuid + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, responseContent);
            return restActivity;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestActivity update(RestActivity existingInstance) throws SocialClientLibException {
        throw new UnsupportedMethodException();
    }

    @Override
    public RestActivity delete(RestActivity existingInstance) throws SocialClientLibException {
        String DELETE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/destroy/" + existingInstance.getId() + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(DELETE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, responseContent);
            return restActivity;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RealtimeListAccess<RestActivity> getActivityStream(RestIdentity restIdentity) throws SocialClientLibException {
        return this.getActivityStream(restIdentity, null);
    }

    @Override
    public RealtimeListAccess<RestActivity> getActivityStream(RestIdentity restIdentity, QueryParams queryParams) throws SocialClientLibException {
        return new ActivitiesRealtimeListAccessV1Alpha3(restIdentity, ActivitiesRealtimeListAccessV1Alpha3.ActivityType.ACTIVITY_STREAM, queryParams);
    }

    @Override
    public RealtimeListAccess<RestActivity> getSpacesActivityStream(RestIdentity userRestIdentity) throws SocialClientLibException {
        return this.getSpacesActivityStream(userRestIdentity, null);
    }

    @Override
    public RealtimeListAccess<RestActivity> getSpacesActivityStream(RestIdentity userRestIdentity, QueryParams queryParams) throws SocialClientLibException {
        return new ActivitiesRealtimeListAccessV1Alpha3(userRestIdentity, ActivitiesRealtimeListAccessV1Alpha3.ActivityType.USER_SPACE_ACTIVITIES, queryParams);
    }

    @Override
    public RealtimeListAccess<RestActivity> getConnectionsActivityStream(RestIdentity userRestIdentity) throws SocialClientLibException {
        return this.getConnectionsActivityStream(userRestIdentity, null);
    }

    @Override
    public RealtimeListAccess<RestActivity> getConnectionsActivityStream(RestIdentity restIdentity, QueryParams queryParams) throws SocialClientLibException {
        return new ActivitiesRealtimeListAccessV1Alpha3(restIdentity, ActivitiesRealtimeListAccessV1Alpha3.ActivityType.CONNECTIONS_ACTIVITIES, queryParams);
    }

    @Override
    public RealtimeListAccess<RestActivity> getFeedActivityStream(RestIdentity userRestIdentity) throws SocialClientLibException {
        return this.getFeedActivityStream(userRestIdentity, null);
    }

    @Override
    public RealtimeListAccess<RestActivity> getFeedActivityStream(RestIdentity userRestIdentity, QueryParams queryParams) throws SocialClientLibException {
        return new ActivitiesRealtimeListAccessV1Alpha3(userRestIdentity, ActivitiesRealtimeListAccessV1Alpha3.ActivityType.ACTIVITY_FEED, queryParams);
    }

    @Override
    public RestComment createComment(RestActivity existingRestActivity, RestComment newRestComment) throws SocialClientLibException {
        String CREATE_COMMENT_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/comment.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(CREATE_COMMENT_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH, newRestComment);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestComment restComment = SocialJSONDecodingSupport.parser(RestComment.class, responseContent);
            return restComment;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestComment getComment(String commentId) throws SocialClientLibException {
        throw new UnsupportedMethodException();
    }

    @Override
    public RestComment deleteComment(RestComment existingRestComment) throws SocialClientLibException {
        String DELETE_COMMENT_REQUEST_URL = BASE_URL + "activity/" + existingRestComment.getActivityId() + "/comment/destroy/" + existingRestComment.getId() + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(DELETE_COMMENT_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            RestComment restComment = SocialJSONDecodingSupport.parser(RestComment.class, responseContent);
            return restComment;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestLike like(RestActivity existingRestActivity) throws SocialClientLibException {
        String LIKE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/like.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(LIKE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            String responseContent = SocialHttpClientSupport.getContent(response);
            JSONObject responseJson = (JSONObject)JSONValue.parse((String)responseContent);
            if (((Boolean)responseJson.get((Object)"liked")).booleanValue()) {
                return new RestLike(existingRestActivity.getId(), null);
            }
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, "invalid response", null);
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, "invalid response", null);
        }
    }

    @Override
    public RestLike unlike(RestActivity existingRestActivity) throws SocialClientLibException {
        String LIKE_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + existingRestActivity.getId() + "/like/destroy.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executePost(LIKE_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            String responseContent = SocialHttpClientSupport.getContent(response);
            JSONObject responseJson = (JSONObject)JSONValue.parse((String)responseContent);
            if (!((Boolean)responseJson.get((Object)"liked")).booleanValue()) {
                return new RestLike(existingRestActivity.getId(), null);
            }
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, "invalid response", null);
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }

    @Override
    public RestActivity get(String activityId, QueryParams queryParams) throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = BASE_URL + "activity/" + activityId + ".json?" + queryParams.buildQuery();
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            String responseContent = SocialHttpClientSupport.getContent(response);
            RestActivity restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, responseContent);
            return restActivity;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityServiceImplV1Alpha3.class, e.getMessage(), e);
        }
    }
}

