/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.UnsupportedMethodException;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.IdentityService;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.exoplatform.social.client.api.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

public class IdentityServiceImplV1Alpha2
implements IdentityService<RestIdentity> {
    private static final String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);

    @Override
    public RestIdentity getIdentity(String identityProvider, String remoteId) throws SocialClientLibException {
        if (identityProvider == null || remoteId == null) {
            throw new NullPointerException("Input param can not be null.");
        }
        String targetURL = BASE_URL + "identity/" + identityProvider + "/" + remoteId + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            return SocialJSONDecodingSupport.parser(RestIdentity.class, response);
        }
        catch (IOException ioex) {
            throw new ServiceException(IdentityServiceImplV1Alpha2.class, "IOException when reads Json Content.", ioex);
        }
        catch (ParseException pex) {
            throw new ServiceException(IdentityServiceImplV1Alpha2.class, "ParseException when reads Json Content.", pex);
        }
    }

    @Override
    public String getIdentityId(String provider, String remoteId) throws SocialClientLibException {
        return this.getIdentity(provider, remoteId).getId();
    }

    @Override
    public RestIdentity create(RestIdentity newInstance) throws SocialClientLibException {
        throw new UnsupportedMethodException("Not Supported Yet.");
    }

    @Override
    public RestIdentity get(String uuid) throws SocialClientLibException {
        if (uuid == null) {
            throw new NullPointerException("Input param can not be null");
        }
        String targetURL = BASE_URL + "identity/" + uuid + ".json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            return SocialJSONDecodingSupport.parser(RestIdentity.class, response);
        }
        catch (IOException ioex) {
            throw new ServiceException(IdentityServiceImplV1Alpha2.class, "IOException when reads Json Content.", ioex);
        }
        catch (ParseException pex) {
            throw new ServiceException(IdentityServiceImplV1Alpha2.class, "ParseException when reads Json Content.", pex);
        }
    }

    @Override
    public RestIdentity update(RestIdentity existingInstance) throws SocialClientLibException {
        throw new UnsupportedMethodException("Not Supported Yet.");
    }

    @Override
    public RestIdentity delete(RestIdentity existingInstance) throws SocialClientLibException {
        throw new UnsupportedMethodException("Not Supported Yet.");
    }
}

