/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.api.model;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.model.Model;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.exoplatform.social.client.api.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

public class RestComment
extends Model {
    public RestComment() {
    }

    public RestComment(String id, String identityId, String activityId, Long postedTime, String createdAt) {
        this.setId(id);
        this.setIdentityId(identityId);
        this.setActivityId(activityId);
        this.setPostedTime(postedTime);
        this.setCreatedAt(createdAt);
    }

    public String getId() {
        return this.getFieldAsString(Field.ID.toString());
    }

    public void setId(String id) {
        this.setField(Field.ID.toString(), id);
    }

    public String getIdentityId() {
        return this.getFieldAsString(Field.IDENTITY_ID.toString());
    }

    public void setIdentityId(String identityId) {
        this.setField(Field.IDENTITY_ID.toString(), identityId);
    }

    public String getActivityId() {
        return this.getFieldAsString(Field.ACTIVITY_ID.toString());
    }

    public void setActivityId(String activityId) {
        this.setField(Field.ACTIVITY_ID.toString(), activityId);
    }

    public String getText() {
        return this.getFieldAsString(Field.TEXT.toString());
    }

    public void setText(String content) {
        this.setField(Field.TEXT.toString(), content);
    }

    public Long getPostedTime() {
        return (Long)this.getField(Field.POSTED_TIME.toString());
    }

    public void setPostedTime(Long postedTime) {
        this.setField(Field.POSTED_TIME.toString(), postedTime);
    }

    public String getCreatedAt() {
        return this.getFieldAsString(Field.CREATED_AT.toString());
    }

    public void setCreatedAt(String createdAt) {
        this.setField(Field.CREATED_AT.toString(), createdAt);
    }

    public RestActivity getActivity() {
        RestActivity restActivity = null;
        try {
            String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);
            String requestURL = BASE_URL + "restActivity/" + this.getActivityId() + ".json";
            HttpResponse response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            restActivity = SocialJSONDecodingSupport.parser(RestActivity.class, response);
        }
        catch (IOException e) {
            throw new ServiceException(RestComment.class, "IOException when reads Json Content.", e);
        }
        catch (ParseException e) {
            throw new ServiceException(RestComment.class, "ParseException when reads Json Content.", e);
        }
        return restActivity;
    }

    public RestIdentity getIdentity() {
        RestIdentity restIdentity = null;
        try {
            String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);
            String requestURL = BASE_URL + "restIdentity/" + this.getIdentityId() + ".json";
            HttpResponse response = SocialHttpClientSupport.executeGet(requestURL, SocialHttpClient.POLICY.BASIC_AUTH);
            restIdentity = SocialJSONDecodingSupport.parser(RestIdentity.class, response);
        }
        catch (IOException e) {
            throw new ServiceException(RestComment.class, "IOException when reads Json Content.", e);
        }
        catch (ParseException e) {
            throw new ServiceException(RestComment.class, "ParseException when reads Json Content.", e);
        }
        return restIdentity;
    }

    public RestIdentity getPosterIdentity() {
        String posterIdentityJson = this.getFieldAsString(Field.POSTER_IDENTITY.toString());
        try {
            return posterIdentityJson == null ? new RestIdentity() : SocialJSONDecodingSupport.parser(RestIdentity.class, posterIdentityJson);
        }
        catch (ParseException pex) {
            return new RestIdentity();
        }
    }

    public void setPosterIdentity(RestIdentity restIdentity) {
        this.setField(Field.POSTER_IDENTITY.toString(), restIdentity);
    }

    public static enum Field {
        ID("id"),
        IDENTITY_ID("identityId"),
        ACTIVITY_ID("activityId"),
        TEXT("text"),
        POSTED_TIME("postedTime"),
        CREATED_AT("createdAt"),
        POSTER_IDENTITY("posterIdentity");

        private final String jsonString;

        private Field(String jsonString) {
            this.jsonString = jsonString;
        }

        public String toString() {
            return this.jsonString;
        }
    }
}

