/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.model.RestSpace;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.service.SpaceService;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.exoplatform.social.client.api.util.SocialJSONDecodingSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class SpaceServiceImplV1Alpha3
implements SpaceService<RestSpace> {
    private static final String MY_SPACES_URL = "/rest/private/portal/social/spaces/mySpaces/show.json";

    @Override
    public List<RestSpace> getMySocialSpaces() {
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(MY_SPACES_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            return this.getListOfSpacesFromResponse(response);
        }
        catch (IOException ioex) {
            throw new ServiceException(SpaceServiceImplV1Alpha3.class, "IOException when reading Json Content.", ioex);
        }
        catch (ParseException pex) {
            throw new ServiceException(SpaceServiceImplV1Alpha3.class, "ParseException when reading Json Content.", pex);
        }
        catch (SocialClientLibException socialClientLibException) {
            return null;
        }
    }

    private List<RestSpace> getListOfSpacesFromResponse(HttpResponse response) throws ParseException {
        try {
            JSONObject root = (JSONObject)JSONValue.parse((String)SocialHttpClientSupport.getContent(response));
            JSONArray spaces = (JSONArray)root.get((Object)"spaces");
            List<RestSpace> listSpaces = SocialJSONDecodingSupport.JSONArrayObjectParser(RestSpace.class, spaces.toJSONString());
            return listSpaces;
        }
        catch (Exception e) {
            throw new ServiceException(SpaceServiceImplV1Alpha3.class, "Cannot parse the Json Content", e);
        }
    }

    @Override
    public RestSpace create(RestSpace newInstance) throws SocialClientLibException {
        throw new SocialClientLibException("Not Supported");
    }

    @Override
    public RestSpace get(String uuid) throws SocialClientLibException {
        throw new SocialClientLibException("Not Supported");
    }

    @Override
    public RestSpace update(RestSpace existingInstance) throws SocialClientLibException {
        throw new SocialClientLibException("Not Supported");
    }

    @Override
    public RestSpace delete(RestSpace existingInstance) throws SocialClientLibException {
        throw new SocialClientLibException("Not Supported");
    }
}

