/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.model;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;

public class ExoSocialActivityImpl
implements ExoSocialActivity {
    public static final String ACTIVITY_METADATA_OBJECT_TYPE_PARAM = "metadataObjectType";
    public static final String ACTIVITY_METADATA_OBJECT_ID_PARAM = "metadataObjectId";
    public static final String ACTIVITY_METADATA_OBJECT_PARENT_ID_PARAM = "metadataObjectParentId";
    public static final String DEFAULT_ACTIVITY_METADATA_OBJECT_TYPE = "activity";
    private String id;
    private String externalId;
    private ActivityStream activityStream;
    private boolean isAComment = false;
    private String type;
    private String[] replyToId;
    private boolean isHiddenActivity = false;
    private boolean isLockedActivity = false;
    private String[] likeIdentityIds;
    private Set<ActivityShareAction> shareActions;
    private String name;
    private String title;
    private String titleId;
    private String summary;
    private String body;
    private String bodyId;
    private String appId;
    private Long postedTime;
    private Date updated;
    private boolean pinned;
    private String pinDate;
    private Long pinAuthorId;
    private long cacheTime;
    private String url;
    private Map<String, String> templateParams;
    private Map<String, Object> linkedProcessedEntities;
    private String permaLink;
    private String[] mentionedIds;
    private String[] commentedIds;
    private String posterId;
    private String parentCommentId;
    private String parentId;
    private List<ActivityFile> files;
    private Map<String, List<MetadataItem>> metadatas;
    private String userId;
    private String spaceId;
    private Float priority;

    public ExoSocialActivityImpl() {
        this.init();
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle) {
        this.init();
        this.setUserId(userId);
        this.type = activityType;
        this.setTitle(activityTitle);
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle, String activityBody) {
        this(userId, activityType, activityTitle);
        this.setBody(activityBody);
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle, String activityBody, boolean isAComment) {
        this(userId, activityType, activityTitle);
        this.setBody(activityBody);
        this.isAComment = isAComment;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public final ActivityStream getActivityStream() {
        if (this.activityStream == null) {
            this.activityStream = new ActivityStreamImpl();
        }
        return this.activityStream;
    }

    @Override
    public final void setActivityStream(ActivityStream providedAS) {
        this.activityStream = providedAS;
    }

    @Override
    public final boolean isComment() {
        return this.isAComment;
    }

    @Override
    public final void isComment(boolean isCommentOrNot) {
        this.isAComment = isCommentOrNot;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final void setType(String activityType) {
        this.type = activityType;
    }

    @Override
    public String[] getReplyToId() {
        return this.replyToId;
    }

    @Override
    public final void setReplyToId(String[] replyToIdentityId) {
        this.replyToId = replyToIdentityId;
    }

    @Override
    public final boolean isHidden() {
        return this.isHiddenActivity;
    }

    @Override
    public final void isHidden(boolean isHiddenOrNot) {
        this.isHiddenActivity = isHiddenOrNot;
    }

    @Override
    public final boolean isLocked() {
        return this.isLockedActivity;
    }

    @Override
    public final void isLocked(boolean isLockedOrNot) {
        this.isLockedActivity = isLockedOrNot;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @Override
    public String getPinDate() {
        return this.pinDate;
    }

    @Override
    public void setPinDate(String pinDate) {
        this.pinDate = pinDate;
    }

    @Override
    public Long getPinAuthorId() {
        return this.pinAuthorId;
    }

    @Override
    public void setPinAuthorId(Long pinAuthorId) {
        this.pinAuthorId = pinAuthorId;
    }

    @Override
    public final String[] getLikeIdentityIds() {
        if (this.likeIdentityIds != null) {
            return Arrays.copyOf(this.likeIdentityIds, this.likeIdentityIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public final Set<ActivityShareAction> getShareActions() {
        return this.shareActions;
    }

    @Override
    public void setShareActions(Set<ActivityShareAction> shareActions) {
        this.shareActions = shareActions;
    }

    @Override
    public int getNumberOfLikes() {
        return this.likeIdentityIds == null ? 0 : this.likeIdentityIds.length;
    }

    @Override
    public final void setLikeIdentityIds(String[] identityIds) {
        this.likeIdentityIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public final String getStreamOwner() {
        return this.activityStream.getPrettyId();
    }

    @Override
    public final void setStreamOwner(String activitySO) {
        this.activityStream.setPrettyId(activitySO);
    }

    @Override
    public final String getStreamId() {
        return this.activityStream.getId();
    }

    @Override
    public final void setStreamId(String sId) {
        this.activityStream.setId(sId);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String activityName) {
        this.name = activityName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitleId() {
        return this.titleId;
    }

    @Override
    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    @Override
    public final String getSummary() {
        return this.summary;
    }

    @Override
    public final void setSummary(String activitySummary) {
        this.summary = activitySummary;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getBodyId() {
        return this.bodyId;
    }

    @Override
    public void setBodyId(String bodyId) {
        this.bodyId = bodyId;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public Long getPostedTime() {
        return this.postedTime;
    }

    @Override
    public void setPostedTime(Long postedTime) {
        this.postedTime = postedTime;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    @Override
    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    @Override
    public final String getPermaLink() {
        return this.permaLink;
    }

    @Override
    public final void setPermanLink(String activityPermaLink) {
        this.permaLink = activityPermaLink;
    }

    @Override
    public final String getStreamFaviconUrl() {
        return this.activityStream.getFaviconUrl();
    }

    @Override
    public final String getStreamSourceUrl() {
        return this.activityStream.getPermaLink();
    }

    @Override
    public final String getStreamTitle() {
        return this.activityStream.getTitle();
    }

    @Override
    public final String getStreamUrl() {
        return this.activityStream.getPermaLink();
    }

    @Override
    public final String[] getMentionedIds() {
        if (this.mentionedIds != null) {
            return Arrays.copyOf(this.mentionedIds, this.mentionedIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public final void setMentionedIds(String[] identityIds) {
        this.mentionedIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public final String[] getCommentedIds() {
        if (this.commentedIds != null) {
            return Arrays.copyOf(this.commentedIds, this.commentedIds.length);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public final void setCommentedIds(String[] identityIds) {
        this.commentedIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated != null ? new Date(updated) : new Date(this.getPostedTime());
    }

    private void init() {
        Date date = new Date();
        this.setPostedTime(date.getTime());
        this.setUpdated(date.getTime());
        this.activityStream = new ActivityStreamImpl();
    }

    @Override
    public String getPosterId() {
        return this.posterId;
    }

    @Override
    public void setPosterId(String posterId) {
        this.posterId = posterId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getParentCommentId() {
        return this.parentCommentId;
    }

    @Override
    public void setParentCommentId(String parentCommentId) {
        this.parentCommentId = parentCommentId;
    }

    @Override
    public List<ActivityFile> getFiles() {
        return this.files;
    }

    @Override
    public void setFiles(List<ActivityFile> files) {
        this.files = files;
    }

    @Override
    public Map<String, List<MetadataItem>> getMetadatas() {
        return this.metadatas;
    }

    @Override
    public void setMetadatas(Map<String, List<MetadataItem>> metadatas) {
        this.metadatas = metadatas;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    @Override
    public Float getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Float priority) {
        this.priority = priority;
    }

    @Override
    public Map<String, Object> getLinkedProcessedEntities() {
        return this.linkedProcessedEntities;
    }

    @Override
    public void setLinkedProcessedEntities(Map<String, Object> linkedProcessedEntities) {
        this.linkedProcessedEntities = linkedProcessedEntities;
    }

    @Override
    public String getMetadataObjectType() {
        if (this.hasSpecificMetadataObject()) {
            return this.templateParams.get(ACTIVITY_METADATA_OBJECT_TYPE_PARAM);
        }
        return DEFAULT_ACTIVITY_METADATA_OBJECT_TYPE;
    }

    @Override
    public String getMetadataObjectId() {
        if (this.hasSpecificMetadataObject()) {
            return this.templateParams.get(ACTIVITY_METADATA_OBJECT_ID_PARAM);
        }
        return this.getId();
    }

    @Override
    public String getMetadataObjectParentId() {
        if (this.hasSpecificMetadataObject()) {
            return this.templateParams.get(ACTIVITY_METADATA_OBJECT_PARENT_ID_PARAM);
        }
        return this.getParentId();
    }

    @Override
    public void setMetadataObjectType(String objectType) {
        if (this.templateParams == null) {
            this.setTemplateParams(new HashMap<String, String>());
        }
        this.templateParams.put(ACTIVITY_METADATA_OBJECT_TYPE_PARAM, objectType);
    }

    @Override
    public void setMetadataObjectId(String objectId) {
        if (this.templateParams == null) {
            this.setTemplateParams(new HashMap<String, String>());
        }
        this.templateParams.put(ACTIVITY_METADATA_OBJECT_ID_PARAM, objectId);
    }

    @Override
    public void setMetadataObjectParentId(String objectParentId) {
        if (this.templateParams == null) {
            this.setTemplateParams(new HashMap<String, String>());
        }
        this.templateParams.put(ACTIVITY_METADATA_OBJECT_PARENT_ID_PARAM, objectParentId);
    }

    @Override
    public MetadataObject getMetadataObject() {
        return new MetadataObject(this.getMetadataObjectType(), this.getMetadataObjectId(), this.getMetadataObjectParentId(), StringUtils.isBlank((CharSequence)this.spaceId) ? 0L : Long.parseLong(this.spaceId));
    }

    @Override
    public boolean hasSpecificMetadataObject() {
        return this.templateParams != null && this.templateParams.containsKey(ACTIVITY_METADATA_OBJECT_TYPE_PARAM) && !DEFAULT_ACTIVITY_METADATA_OBJECT_TYPE.equals(this.templateParams.get(ACTIVITY_METADATA_OBJECT_TYPE_PARAM));
    }

    public String toString() {
        return "ExoSocialActivity[id = " + this.getId() + ",title=" + this.getTitle() + ",lastModified= " + this.getUpdated().getTime() + " ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExoSocialActivityImpl)) {
            return false;
        }
        ExoSocialActivityImpl that = (ExoSocialActivityImpl)o;
        return this.getId() == null ? that.getId() == null : this.getId().equals(that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

