/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.router.regex;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.social.common.router.regex.ExoMatcher;
import org.exoplatform.social.common.router.regex.ExoMatcherImpl;

public class ExoPattern {
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\(\\{(\\w+)\\}");
    private Pattern pattern;
    private String namedPattern;
    private Map<String, List<ExoGroupData>> groupInfo;

    public static ExoPattern compile(String regex) {
        return new ExoPattern(regex, 0);
    }

    public static ExoPattern compile(String regex, int flags) {
        return new ExoPattern(regex, flags);
    }

    private ExoPattern(String regex, int flags) {
        this.namedPattern = regex;
        this.pattern = ExoPattern.buildStandardPattern(regex, flags);
        this.groupInfo = ExoPattern.extractGroupInfo(regex);
    }

    public int indexOf(String groupName) {
        return this.indexOf(groupName, 0);
    }

    public int indexOf(String groupName, int index) {
        List<ExoGroupData> list;
        int idx = -1;
        if (this.groupInfo.containsKey(groupName) && index < (list = this.groupInfo.get(groupName)).size()) {
            idx = list.get(index).getGroupIndex();
        }
        return idx;
    }

    public ExoMatcher matcher(CharSequence input) {
        return new ExoMatcherImpl(this, input);
    }

    public boolean matches(String s) {
        return this.pattern.matcher(s).matches();
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.namedPattern;
    }

    private static boolean isEscapedParent(String s, int pos) {
        int numSlashes = 0;
        while (pos > 0 && s.charAt(pos - 1) == '\\') {
            --pos;
            ++numSlashes;
        }
        return numSlashes % 2 != 0;
    }

    private static boolean isNoncapturingParent(String s, int pos) {
        int len = s.length();
        boolean isLookbehind = false;
        if (pos >= 0 && pos + 4 < len) {
            String pre = s.substring(pos, pos + 4);
            isLookbehind = pre.equals("(?<=") || pre.equals("(?<!");
        }
        return pos >= 0 && pos + 2 < len && s.charAt(pos + 1) == '?' && (isLookbehind || s.charAt(pos + 2) != '<');
    }

    private static int countOpenParents(String s, int pos) {
        Pattern p = Pattern.compile("\\(");
        Matcher m = p.matcher(s.subSequence(0, pos));
        int numParens = 0;
        while (m.find()) {
            String match = m.group(0);
            if (ExoPattern.isEscapedParent(s, m.start()) || !match.equals("(") || ExoPattern.isNoncapturingParent(s, m.start())) continue;
            ++numParens;
        }
        return numParens;
    }

    public static Map<String, List<ExoGroupData>> extractGroupInfo(String namedPattern) {
        LinkedHashMap<String, List<ExoGroupData>> groupInfo = new LinkedHashMap<String, List<ExoGroupData>>();
        Matcher matcher = GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            int pos = matcher.start();
            if (ExoPattern.isEscapedParent(namedPattern, pos)) continue;
            String name = matcher.group(1);
            int groupIndex = ExoPattern.countOpenParents(namedPattern, pos);
            List list = groupInfo.containsKey(name) ? (List)groupInfo.get(name) : new ArrayList();
            list.add(new ExoGroupData(groupIndex, pos));
            groupInfo.put(name, list);
        }
        return groupInfo;
    }

    private static Pattern buildStandardPattern(String namedPattern, Integer flags) {
        StringBuilder s = new StringBuilder(namedPattern);
        Matcher m = GROUP_PATTERN.matcher(s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (ExoPattern.isEscapedParent(s.toString(), start)) continue;
            s.replace(start, end, "(");
            m.reset();
        }
        return Pattern.compile(s.toString(), flags);
    }

    private static class ExoGroupData {
        private int pos;
        private int groupIndex;

        ExoGroupData(int groupIndex, int pos) {
            this.groupIndex = groupIndex;
            this.pos = pos;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

