/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service;

import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.social.common.TestSocialServiceContext;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.ServiceContext;
import org.exoplatform.social.common.service.impl.ProcessorContextImpl;
import org.exoplatform.social.common.service.utils.ConsoleUtils;

public class AsyncProcessorTest
extends TestSocialServiceContext {
    private static AtomicInteger currentNumber = new AtomicInteger(0);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void config() {
    }

    @Override
    protected AsyncProcessor createAsyncProcessor() {
        return new AsyncProcessor(){

            public ProcessContext process(ProcessContext processContext) {
                processContext.setProperty("result", (Object)"done");
                processContext.done(true);
                return processContext;
            }

            public String getName() {
                return "AsyncProcessor";
            }

            public ProcessContext process(ProcessContext processorContext, AsyncCallback callback) {
                ProcessContext got = processorContext;
                try {
                    got = this.process(processorContext);
                    Thread.sleep(10L);
                    if (got.isDone()) {
                        callback.done(got);
                    }
                }
                catch (Exception e) {
                    processorContext.setException((Throwable)e);
                }
                return got;
            }

            public void start(ProcessContext processContext) {
                processContext.trace(this.getName(), "start()");
            }

            public void end(ProcessContext processContext) {
                processContext.trace(this.getName(), "end()");
            }
        };
    }

    public void testServiceContext() throws Exception {
        ProcessorContextImpl params = new ProcessorContextImpl(this.getContext());
        params.setProcessorName("AsyncProcessorTest");
        params.setProperty("test0", (Object)"test0");
        params.setProperty("test1", (Object)"test1");
        params = this.getExecutor().execute((ServiceContext)new ServiceContext<ProcessContext>(){

            public ProcessContext execute(ProcessContext processContext) {
                processContext.setProperty("result", (Object)"done");
                return processContext;
            }
        }, (ProcessContext)params);
        AsyncProcessorTest.assertEquals((String)"done", (String)((String)params.getProperty("result", String.class)));
    }

    public void testAysncCallback() throws Exception {
        ProcessorContextImpl params = new ProcessorContextImpl(this.getContext());
        params.setProcessorName("AsyncProcessorTest");
        params.setProperty("test0", (Object)"test0");
        params.setProperty("test1", (Object)"test1");
        params.totalProcesses(80);
        for (int i = 0; i < 80; ++i) {
            ProcessContext got = this.serviceExecute((ProcessContext)params, this.createAsyncCallback());
            Thread.sleep(10L);
            AsyncProcessorTest.assertEquals((String)"done", (String)((String)got.getProperty("result", String.class)));
        }
    }

    private AsyncCallback createAsyncCallback() {
        return new AsyncCallback(){

            public void done(ProcessContext processContext) {
                int value = currentNumber.incrementAndGet();
                int percent = value * 100 / processContext.getTotalProcesses();
                ConsoleUtils.logProgBar((int)percent);
            }
        };
    }
}

