/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.router;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.AbstractCommonTest;
import org.exoplatform.social.common.router.ExoRouter;

public class ExoRouterTest
extends AbstractCommonTest {
    private static final Log LOG = ExoLogger.getLogger(ExoRouterTest.class);
    private ExoRouter exoRouter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.exoRouter = (ExoRouter)this.getContainer().getComponentInstanceOfType(ExoRouter.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExoRouterConfig() throws Exception {
        ExoRouterTest.assertNotNull((Object)this.exoRouter);
    }

    public void testRouterForActivityShow() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/activity/4437hg2121");
        this.assertRouter(route, "activity.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("activityID", "4437hg2121");
            }
        });
    }

    public void testRouterForActivityOwnerShow() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/activities/mary");
        this.assertRouter(route, "activity.stream.owner.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "mary");
            }
        });
    }

    public void testRouterForProfileShow() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/profile/mary");
        this.assertRouter(route, "profile.owner.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "mary");
            }
        });
    }

    public void testRouterForConnectionsShow() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/connections/network/mary");
        this.assertRouter(route, "connections.network.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "mary");
            }
        });
        route = ExoRouter.route((String)"/connections/all-people/demo");
        this.assertRouter(route, "connections.network.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "demo");
            }
        });
        route = ExoRouter.route((String)"/connections/receivedInvitations/root");
        this.assertRouter(route, "connections.network.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "root");
            }
        });
        route = ExoRouter.route((String)"/connections/pendingRequests/john.vu");
        this.assertRouter(route, "connections.network.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("streamOwnerId", "john.vu");
            }
        });
    }

    public void testRouterForSpaceAccess() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"mary-space");
        this.assertRouter(route, "space.access", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("spacePrettyName", "mary-space");
            }
        });
    }

    public void testRouterForSpaceAppAccess() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"mary-space/wiki");
        this.assertRouter(route, "space.app.access", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("spacePrettyName", "mary-space");
                this.put("appName", "wiki");
            }
        });
    }

    public void testRouterForSpaceAppWikiAccess() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"mary-space/wiki/mypage/my_sub_page");
        this.assertRouter(route, "space.app.page.access", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("spacePrettyName", "mary-space");
                this.put("appName", "wiki");
                this.put("page", "mypage/my_sub_page");
            }
        });
    }

    public void testRouterForSpaceWikiAccess() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"mary-space/wiki/technical_space_access");
        this.assertRouter(route, "space.app.page.access", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("spacePrettyName", "mary-space");
                this.put("appName", "wiki");
                this.put("page", "technical_space_access");
            }
        });
    }

    public void testRouterForForumHome() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/ForumService");
        this.assertRouter(route, "forum.home", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
            }
        });
    }

    public void testRouterForSearch() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/SearchForum");
        this.assertRouter(route, "forum.search", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
            }
        });
    }

    public void testRouterForTag() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/Tag");
        this.assertRouter(route, "forum.tag", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
            }
        });
    }

    public void testRouterForShowTopic() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/topic/topic987654321");
        this.assertRouter(route, "forum.topic.show", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
                this.put("topicID", "topic987654321");
            }
        });
    }

    public void testRouterForShowTopicTrue() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/topic/topic987654321/reply");
        this.assertRouter(route, "forum.topic.reply", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
                this.put("topicID", "topic987654321");
            }
        });
    }

    public void testRouterForShowTopicFalse() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/topic/topic987654321/quote");
        this.assertRouter(route, "forum.topic.quote", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
                this.put("topicID", "topic987654321");
            }
        });
    }

    public void testRouterForShowTopicWrong() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/fail/topic987654321");
        ExoRouterTest.assertNull((Object)route);
    }

    public void testRouterForShowTopicPage() throws Exception {
        ExoRouter.Route route = ExoRouter.route((String)"/12345/topic/topic987654321/page/3");
        this.assertRouter(route, "forum.topic.page", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("pageID", "12345");
                this.put("topicID", "topic987654321");
                this.put("pageNo", "3");
            }
        });
    }

    private void assertRouter(ExoRouter.Route route, String actionName, Map<String, String> expectedArgs) {
        ExoRouterTest.assertNotNull((Object)route);
        ExoRouterTest.assertEquals((String)actionName, (String)route.action);
        for (Map.Entry<String, String> entry : expectedArgs.entrySet()) {
            ExoRouterTest.assertEquals((String)entry.getValue(), (String)((String)route.localArgs.get(entry.getKey())));
        }
    }
}

