/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.concurrent.TimeUnit;

public class LogWatch
implements Cloneable {
    private static final long NANOS_IN_A_MILLI = 1000000L;
    private long startTime;
    private long nanoStartTime;
    private long elapsedTime;
    private String process;
    private String message;

    public LogWatch() {
        this("", null);
    }

    public LogWatch(String tag) {
        this(tag, null);
    }

    public LogWatch(String tag, String message) {
        this(System.currentTimeMillis(), -1L, tag, message);
    }

    public LogWatch(long startTime, long elapsedTime, String process, String message) {
        this.startTime = startTime;
        this.nanoStartTime = elapsedTime == -1L ? System.nanoTime() : -1L;
        this.elapsedTime = elapsedTime;
        this.process = process;
        this.message = message;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.nanoStartTime = System.nanoTime();
        this.elapsedTime = -1L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long elapsedTime() {
        this.elapsedTime = this.elapsedTime == -1L ? (System.nanoTime() - this.nanoStartTime) / 1000000L : this.elapsedTime;
        return this.elapsedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long elapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.getElapsedTime(), TimeUnit.NANOSECONDS);
    }

    public String stop() {
        this.elapsedTime = this.elapsedTime();
        return this.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String message = this.getMessage();
        return "start[" + this.getStartTime() + "] time[" + this.elapsedTime() + "] process[" + this.getProcess() + (String)(message == null ? "]" : "] message[" + message + "]");
    }

    private String getProcess() {
        return this.process;
    }

    public LogWatch clone() {
        return new LogWatch(this.startTime, this.nanoStartTime, this.elapsedTime, this.process, this.message);
    }

    public String toString(long value, TimeUnit timeUnit) {
        return String.format("%s %s", value, LogWatch.abbreviate(timeUnit));
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "sec";
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogWatch)) {
            return false;
        }
        LogWatch stopWatch = (LogWatch)o;
        if (this.elapsedTime != stopWatch.elapsedTime) {
            return false;
        }
        if (this.startTime != stopWatch.startTime) {
            return false;
        }
        if (this.nanoStartTime != stopWatch.nanoStartTime) {
            return false;
        }
        if (this.message != null ? !this.message.equals(stopWatch.message) : stopWatch.message != null) {
            return false;
        }
        return !(this.process != null ? !this.process.equals(stopWatch.process) : stopWatch.process != null);
    }

    public int hashCode() {
        int result = (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.nanoStartTime ^ this.nanoStartTime >>> 32);
        result = 31 * result + (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        result = 31 * result + (this.process != null ? this.process.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public LogWatch(long startTime, long nanoStartTime, long elapsedTime, String process, String message) {
        this.startTime = startTime;
        this.nanoStartTime = nanoStartTime;
        this.elapsedTime = elapsedTime;
        this.process = process;
        this.message = message;
    }
}

