/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class LikePlugin
extends BaseNotificationPlugin {
    public static final String ID = "LikePlugin";

    public LikePlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        String[] likersId = activity.getLikeIdentityIds();
        String liker = Utils.getUserId(likersId[likersId.length - 1]);
        ArrayList<String> toUsers = new ArrayList<String>();
        toUsers.add(Utils.getUserId(activity.getPosterId()));
        if (!Utils.isSpaceActivity(activity) && !liker.equals(activity.getStreamOwner())) {
            toUsers.add(activity.getStreamOwner());
        }
        return NotificationInfo.instance().to(Utils.getUserId(activity.getPosterId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.LIKER.getKey(), liker).key(this.getId()).end();
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        String[] likersId = activity.getLikeIdentityIds();
        return !activity.getPosterId().equals(likersId[likersId.length - 1]);
    }
}

