/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ActivityReplyToCommentPlugin", template="war:/notification/templates/ActivityReplyToCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityCommentPlugin", template="war:/notification/templates/ActivityCommentPlugin.gtmpl"), @TemplateConfig(pluginId="EditActivityPlugin", template="war:/notification/templates/EditActivityPlugin.gtmpl"), @TemplateConfig(pluginId="EditCommentPlugin", template="war:/notification/templates/EditCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityMentionPlugin", template="war:/notification/templates/ActivityMentionPlugin.gtmpl"), @TemplateConfig(pluginId="LikePlugin", template="war:/notification/templates/LikePlugin.gtmpl"), @TemplateConfig(pluginId="LikeCommentPlugin", template="war:/notification/templates/LikeCommentPlugin.gtmpl"), @TemplateConfig(pluginId="NewUserPlugin", template="war:/notification/templates/NewUserPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivityPlugin", template="war:/notification/templates/PostActivityPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivitySpaceStreamPlugin", template="war:/notification/templates/PostActivitySpaceStreamPlugin.gtmpl"), @TemplateConfig(pluginId="RelationshipReceivedRequestPlugin", template="war:/notification/templates/RelationshipReceivedRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestJoinSpacePlugin", template="war:/notification/templates/RequestJoinSpacePlugin.gtmpl"), @TemplateConfig(pluginId="SpaceInvitationPlugin", template="war:/notification/templates/SpaceInvitationPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    private static final Log LOG = ExoLogger.getLogger(MailTemplateProvider.class);
    private AbstractTemplateBuilder replyToComment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity commentActivity = Utils.getActivityManager().getActivity(commentId);
            ExoSocialActivity parentCommentActivity = Utils.getActivityManager().getActivity(commentActivity.getParentCommentId());
            Identity identity = Utils.getIdentityManager().getIdentity(commentActivity.getPosterId(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String subCommentTitle = SocialNotificationUtils.processImageTitle(commentActivity.getTitle(), imagePlaceHolder);
            String commentTitle = SocialNotificationUtils.processImageTitle(parentCommentActivity.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"COMMENT_REPLY", (Object)NotificationUtils.processLinkTitle((String)subCommentTitle));
            templateContext.put((Object)"COMMENT", (Object)NotificationUtils.processLinkTitle((String)commentTitle));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment_reply", activity.getId() + "-" + parentCommentActivity.getId() + "-" + commentActivity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment_reply", activity.getId() + "-" + parentCommentActivity.getId() + "-" + commentActivity.getId()));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, parentCommentActivity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(first.getTo(), templateContext);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            LinkedHashMap<String, List<Pair<String, String>>> activityUserComments = new LinkedHashMap<String, List<Pair<String, String>>>();
            try {
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
                for (NotificationInfo message : notifications) {
                    Identity identity;
                    ExoSocialActivity parentCommentActivity;
                    String commentId = message.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
                    ExoSocialActivity commentActivity = Utils.getActivityManager().getActivity(commentId);
                    if (commentActivity == null || commentActivity.getParentCommentId() == null || !(parentCommentActivity = Utils.getActivityManager().getActivity(commentActivity.getParentCommentId())).isComment() || (identity = Utils.getIdentityManager().getIdentity(parentCommentActivity.getPosterId(), true)) == null || StringUtils.isBlank((String)message.getTo()) || !message.getTo().equals(identity.getRemoteId())) continue;
                    String poster = message.getValueOwnerParameter("poster");
                    String title = SocialNotificationUtils.processImageTitle(commentActivity.getTitle(), imagePlaceHolder);
                    ImmutablePair userComment = new ImmutablePair((Object)poster, (Object)title);
                    ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(commentActivity);
                    SocialNotificationUtils.processInforSendTo(receiverMap, parentActivity.getId(), poster);
                    SocialNotificationUtils.processInforUserComments(activityUserComments, parentActivity.getId(), (Pair<String, String>)userComment);
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, activityUserComments, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder comment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity comment = null;
            if (StringUtils.isNotBlank((String)commentId)) {
                comment = Utils.getActivityManager().getActivity(commentId);
            }
            if (activity == null) {
                LOG.debug("Activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{activityId, notification.getId()});
                return null;
            }
            if (activity.isComment()) {
                comment = Utils.getActivityManager().getParentActivity(activity);
            }
            if (comment == null) {
                LOG.debug("Comment of activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{commentId, notification.getId()});
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(comment.getPosterId(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(comment.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"COMMENT", (Object)NotificationUtils.processLinkTitle((String)title));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(comment));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment", activity.getId() + "-" + comment.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment", activity.getId() + "-" + comment.getId()));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(first.getTo(), templateContext);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            LinkedHashMap<String, List<Pair<String, String>>> activityUserComments = new LinkedHashMap<String, List<Pair<String, String>>>();
            try {
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
                for (NotificationInfo message : notifications) {
                    Identity identity;
                    Identity spaceIdentity;
                    String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null) continue;
                    String commentId = message.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
                    ExoSocialActivity parentActivity = null;
                    if (StringUtils.isBlank((String)commentId)) {
                        LOG.warn("Attempt to send a mail message with id '{}' and receiver '{}' with empty parameter 'commentId' and activityId = '{}' ", new Object[]{message.getId(), message.getTo(), activityId});
                    } else {
                        parentActivity = activity;
                        activity = Utils.getActivityManager().getActivity(commentId);
                        if (activity == null) continue;
                    }
                    String poster = message.getValueOwnerParameter("poster");
                    if (message.getTo() != null && poster != null && poster.equals(message.getTo())) continue;
                    String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
                    ImmutablePair userComment = new ImmutablePair((Object)poster, (Object)title);
                    if (parentActivity.getStreamOwner() != null && ((spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", parentActivity.getStreamOwner(), true)) == null ? message.getTo() != null && !message.getTo().equals(parentActivity.getStreamOwner()) : parentActivity.getPosterId() != null && (identity = Utils.getIdentityManager().getIdentity(parentActivity.getPosterId(), true)) != null && message.getTo() != null && !message.getTo().equals(identity.getRemoteId()))) continue;
                    SocialNotificationUtils.processInforSendTo(receiverMap, parentActivity.getId(), poster);
                    SocialNotificationUtils.processInforUserComments(activityUserComments, parentActivity.getId(), (Pair<String, String>)userComment);
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, activityUserComments, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder editComment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity comment = null;
            if (StringUtils.isNotBlank((String)commentId)) {
                comment = Utils.getActivityManager().getActivity(commentId);
            }
            if (activity == null) {
                LOG.debug("Activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{activityId, notification.getId()});
                return null;
            }
            if (activity.isComment()) {
                comment = Utils.getActivityManager().getParentActivity(activity);
            }
            if (comment == null) {
                LOG.debug("Comment of activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{commentId, notification.getId()});
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(comment.getPosterId(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(comment.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"COMMENT", (Object)NotificationUtils.processLinkTitle((String)title));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(comment));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment", activity.getId() + "-" + comment.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment", activity.getId() + "-" + comment.getId()));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(first.getTo(), templateContext);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            LinkedHashMap<String, List<Pair<String, String>>> activityUserComments = new LinkedHashMap<String, List<Pair<String, String>>>();
            try {
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
                for (NotificationInfo message : notifications) {
                    Identity identity;
                    Identity spaceIdentity;
                    String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null) continue;
                    String commentId = message.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
                    ExoSocialActivity parentActivity = activity;
                    if (StringUtils.isBlank((String)commentId)) {
                        LOG.warn("Attempt to send a mail message with id '{}' and receiver '{}' with empty parameter 'commentId' and activityId = '{}' ", new Object[]{message.getId(), message.getTo(), activityId});
                    } else {
                        parentActivity = activity;
                        activity = Utils.getActivityManager().getActivity(commentId);
                        if (activity == null) continue;
                    }
                    String poster = message.getValueOwnerParameter("poster");
                    if (message.getTo() != null && poster != null && poster.equals(message.getTo())) continue;
                    String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
                    ImmutablePair userComment = new ImmutablePair((Object)poster, (Object)title);
                    if (parentActivity.getStreamOwner() != null && ((spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", parentActivity.getStreamOwner(), true)) == null ? message.getTo() != null && !message.getTo().equals(parentActivity.getStreamOwner()) : parentActivity.getPosterId() != null && (identity = Utils.getIdentityManager().getIdentity(parentActivity.getPosterId(), true)) != null && message.getTo() != null && !message.getTo().equals(identity.getRemoteId()))) continue;
                    SocialNotificationUtils.processInforSendTo(receiverMap, parentActivity.getId(), poster);
                    SocialNotificationUtils.processInforUserComments(activityUserComments, parentActivity.getId(), (Pair<String, String>)userComment);
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, activityUserComments, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder editActivity = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity == null) {
                LOG.debug("Activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{activityId, notification.getId()});
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"COMMENT", (Object)NotificationUtils.processLinkTitle((String)title));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activityId));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activityId));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(first.getTo(), templateContext);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            LinkedHashMap<String, List<Pair<String, String>>> activityUserComments = new LinkedHashMap<String, List<Pair<String, String>>>();
            try {
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
                for (NotificationInfo message : notifications) {
                    Identity identity;
                    Identity spaceIdentity;
                    String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null) continue;
                    String commentId = message.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
                    ExoSocialActivity parentActivity = null;
                    if (StringUtils.isBlank((String)commentId)) {
                        LOG.warn("Attempt to send a mail message with id '{}' and receiver '{}' with empty parameter 'commentId' and activityId = '{}' ", new Object[]{message.getId(), message.getTo(), activityId});
                    } else {
                        parentActivity = activity;
                        activity = Utils.getActivityManager().getActivity(commentId);
                        if (activity == null) continue;
                    }
                    String poster = message.getValueOwnerParameter("poster");
                    if (message.getTo() != null && poster != null && poster.equals(message.getTo())) continue;
                    String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
                    ImmutablePair userComment = new ImmutablePair((Object)poster, (Object)title);
                    if (parentActivity != null && parentActivity.getStreamOwner() != null && ((spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", parentActivity.getStreamOwner(), true)) != null ? parentActivity.getPosterId() != null && (identity = Utils.getIdentityManager().getIdentity(parentActivity.getPosterId(), true)) != null && message.getTo() != null && !message.getTo().equals(identity.getRemoteId()) : message.getTo() != null && !message.getTo().equals(parentActivity.getStreamOwner()))) continue;
                    parentActivity = parentActivity == null ? activity : parentActivity;
                    SocialNotificationUtils.processInforSendTo(receiverMap, parentActivity.getId(), poster);
                    SocialNotificationUtils.processInforUserComments(activityUserComments, parentActivity.getId(), (Pair<String, String>)userComment);
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, activityUserComments, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder mention = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(identity.getProfile()));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            String body = "";
            if (activity.isComment()) {
                ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
                activityId = parentActivity.getId();
                templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment", activityId + "-" + activity.getId()));
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment", activityId + "-" + activity.getId()));
                String title = MailTemplateProvider.this.getI18N(activity, new Locale(language)).getTitle();
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
                title = SocialNotificationUtils.processImageTitle(title, imagePlaceHolder);
                templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.processLinkTitle((String)title));
                body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            } else {
                templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activityId));
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activityId));
                body = SocialNotificationUtils.getBody(ctx, templateContext, MailTemplateProvider.this.getI18N(activity, new Locale(language)));
            }
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo notification : notifications) {
                    String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null) continue;
                    LinkedList<String> mentionedUsers = new LinkedList<String>();
                    for (String id : activity.getMentionedIds()) {
                        Identity identity;
                        if (id.contains("@")) {
                            id = id.substring(0, id.length() - 2);
                        }
                        if ((identity = Utils.getIdentityManager().getIdentity(id, true)) == null) continue;
                        mentionedUsers.add(identity.getRemoteId());
                    }
                    if (notification.getTo() != null && !mentionedUsers.contains(notification.getTo())) continue;
                    Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
                    if (activity.isComment()) {
                        activity = Utils.getActivityManager().getParentActivity(activity);
                    }
                    SocialNotificationUtils.processInforSendTo(receiverMap, activity.getId(), identity.getRemoteId());
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder like = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            String body;
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("likersId"), true);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"SUBJECT", (Object)title);
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            if (activity.isComment()) {
                ExoSocialActivity activityOfComment = Utils.getActivityManager().getParentActivity(activity);
                templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activityOfComment.getId()));
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activityOfComment.getId()));
                String commentTitle = MailTemplateProvider.this.getI18N(activity, new Locale(language)).getTitle();
                commentTitle = SocialNotificationUtils.processImageTitle(commentTitle, imagePlaceHolder);
                templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.processLinkTitle((String)commentTitle));
                body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            } else {
                templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activity.getId()));
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activity.getId()));
                body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            }
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    Identity identity;
                    String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null || activity.getPosterId() != null && (identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true)) != null && message.getTo() != null && !message.getTo().equals(identity.getRemoteId())) continue;
                    String fromUser = message.getValueOwnerParameter("likersId");
                    Identity identityFrom = Utils.getService(IdentityManager.class).getOrCreateIdentity("organization", fromUser, false);
                    if (identityFrom == null || !Arrays.asList(activity.getLikeIdentityIds()).contains(identityFrom.getId())) continue;
                    SocialNotificationUtils.processInforSendTo(map, activityId, message.getValueOwnerParameter("likersId"));
                }
                writer.append(SocialNotificationUtils.getMessageByIds(map, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder newUser = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String remoteId = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            templateContext.put((Object)"PORTAL_NAME", (Object)NotificationPluginUtils.getBrandingPortalName());
            templateContext.put((Object)"PORTAL_HOME", (Object)NotificationUtils.getPortalHome((String)NotificationPluginUtils.getBrandingPortalName()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
            templateContext.put((Object)"CONNECT_ACTION_URL", (Object)LinkProviderUtils.getInviteToConnectUrl(identity.getRemoteId(), notification.getTo()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    String remoteId = message.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
                    Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
                    if (identity.isDeleted()) continue;
                    SocialNotificationUtils.processInforSendTo(map, first.getKey().getId(), remoteId);
                }
                String portalName = System.getProperty("exo.notifications.portalname", "eXo");
                templateContext.put((Object)"PORTAL_NAME", (Object)portalName);
                templateContext.put((Object)"PORTAL_HOME", (Object)SocialNotificationUtils.buildRedirecUrl("portal_home", portalName, portalName));
                writer.append(SocialNotificationUtils.getMessageByIds(map, templateContext, "new_user"));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder postActivity = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"SUBJECT", (Object)title);
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activity.getId()));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String sendToUser = first.getTo();
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey()));
                    if (activity == null || !activity.getStreamOwner().equals(message.getTo())) continue;
                    SocialNotificationUtils.processInforSendTo(receiverMap, sendToUser, message.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "user"));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder postActivitySpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), true);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(spaceIdentity.getRemoteId());
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(language);
            String title = SocialNotificationUtils.processImageTitle(activity.getTitle(), imagePlaceHolder);
            templateContext.put((Object)"SUBJECT", (Object)title);
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space", space.getId()));
            templateContext.put((Object)"OPEN_URL", (Object)LinkProviderUtils.getOpenLink(activity));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activity.getId()));
            String body = SocialNotificationUtils.getBody(ctx, templateContext, activity);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    Space space;
                    String poster = message.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey());
                    String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                    ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                    if (activity == null || !Arrays.asList((space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner())).getMembers()).contains(message.getTo()) || message.getTo() != null && poster != null && poster.equals(message.getTo())) continue;
                    SocialNotificationUtils.processInforSendTo(map, space.getId(), poster);
                }
                writer.append(SocialNotificationUtils.getMessageInSpace(map, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder relationshipReceived = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            String sender = notification.getValueOwnerParameter("sender");
            String toUser = notification.getTo();
            SocialNotificationUtils.addFooterAndFirstName(toUser, templateContext);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", sender, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"PORTAL_NAME", (Object)System.getProperty("exo.notifications.portalname", "eXo"));
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
            templateContext.put((Object)"ACCEPT_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getConfirmInvitationToConnectUrl(sender, toUser));
            templateContext.put((Object)"REFUSE_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getIgnoreInvitationToConnectUrl(sender, toUser));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    Relationship relationship = Utils.getRelationshipManager().get(message.getValueOwnerParameter(SocialNotificationUtils.RELATIONSHIP_ID.getKey()));
                    if (relationship == null || !relationship.getStatus().name().equals("PENDING") || !relationship.getReceiver().getRemoteId().equals(message.getTo())) continue;
                    SocialNotificationUtils.processInforSendTo(receiverMap, first.getTo(), message.getValueOwnerParameter(SocialNotificationUtils.SENDER.getKey()));
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "connections_request"));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder requestJoinSpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("request_from"), true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space_members", space.getId()));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(userProfile));
            templateContext.put((Object)"VALIDATE_SPACE_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getValidateRequestToJoinSpaceUrl(space.getId(), identity.getRemoteId()));
            templateContext.put((Object)"REFUSE_SPACE_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getRefuseRequestToJoinSpaceUrl(space.getId(), identity.getRemoteId()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    String spaceId = message.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
                    String fromUser = message.getValueOwnerParameter("request_from");
                    Space space = Utils.getSpaceService().getSpaceById(spaceId);
                    if (!ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)fromUser) || !ArrayUtils.contains((Object[])space.getManagers(), (Object)message.getTo())) continue;
                    SocialNotificationUtils.processInforSendTo(map, spaceId, fromUser);
                }
                writer.append(SocialNotificationUtils.getMessageInSpace(map, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };
    private AbstractTemplateBuilder spaceInvitation = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"SPACE_URL", (Object)LinkProviderUtils.getRedirectUrl("space", space.getId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            templateContext.put((Object)"SPACE_AVATAR", (Object)LinkProviderUtils.getSpaceAvatarUrl(space));
            templateContext.put((Object)"ACCEPT_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getAcceptInvitationToJoinSpaceUrl(space.getId(), notification.getTo()));
            templateContext.put((Object)"REFUSE_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getIgnoreInvitationToJoinSpaceUrl(space.getId(), notification.getTo()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
            try {
                for (NotificationInfo message : notifications) {
                    String spaceId = message.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
                    Space space = Utils.getSpaceService().getSpaceById(spaceId);
                    if (space == null) {
                        LOG.info("Can't find space with id '{}'. Mail notification with id '{}' will not be sent", new Object[]{spaceId, message.getId()});
                        continue;
                    }
                    if (!ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)first.getTo())) continue;
                    SocialNotificationUtils.processInforSendTo(receiverMap, first.getTo(), spaceId);
                }
                writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext, "space"));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }
    };

    protected ExoSocialActivity getI18N(ExoSocialActivity activity, Locale locale) {
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)PortalContainer.getInstance().getComponentInstanceOfType(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            activity = i18NActivityProcessor.process(activity, locale);
        }
        return activity;
    }

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"ActivityCommentPlugin"), this.comment);
        this.templateBuilders.put(PluginKey.key((String)"EditCommentPlugin"), this.editComment);
        this.templateBuilders.put(PluginKey.key((String)"EditActivityPlugin"), this.editActivity);
        this.templateBuilders.put(PluginKey.key((String)"ActivityReplyToCommentPlugin"), this.replyToComment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityMentionPlugin"), this.mention);
        this.templateBuilders.put(PluginKey.key((String)"LikePlugin"), this.like);
        this.templateBuilders.put(PluginKey.key((String)"LikeCommentPlugin"), this.like);
        this.templateBuilders.put(PluginKey.key((String)"NewUserPlugin"), this.newUser);
        this.templateBuilders.put(PluginKey.key((String)"PostActivityPlugin"), this.postActivity);
        this.templateBuilders.put(PluginKey.key((String)"PostActivitySpaceStreamPlugin"), this.postActivitySpace);
        this.templateBuilders.put(PluginKey.key((String)"RelationshipReceivedRequestPlugin"), this.relationshipReceived);
        this.templateBuilders.put(PluginKey.key((String)"RequestJoinSpacePlugin"), this.requestJoinSpace);
        this.templateBuilders.put(PluginKey.key((String)"SpaceInvitationPlugin"), this.spaceInvitation);
    }
}

