/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class NewUserPlugin
extends BaseNotificationPlugin {
    public static final String ID = "NewUserPlugin";

    public NewUserPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Profile profile = (Profile)ctx.value(SocialNotificationUtils.PROFILE);
        String remoteId = profile.getIdentity().getRemoteId();
        try {
            UserSettingService userSettingService = (UserSettingService)CommonsUtils.getService(UserSettingService.class);
            userSettingService.initDefaultSettings(remoteId);
            return NotificationInfo.instance().key(this.getId()).with(SocialNotificationUtils.REMOTE_ID.getKey(), remoteId).setSendAll(true).setFrom(remoteId).end();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

