/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityCommentPlugin
extends BaseNotificationPlugin {
    public static final String ID = "ActivityCommentPlugin";
    protected boolean isSubComment = false;

    public ActivityCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        HashSet<String> receivers = new HashSet<String>();
        if (StringUtils.isNotBlank((String)comment.getParentCommentId())) {
            ExoSocialActivity parentComment = Utils.getActivityManager().getActivity(comment.getParentCommentId());
            String parentCommentUserPosterId = Utils.getUserId(parentComment.getPosterId());
            if (this.isSubComment) {
                Utils.sendToActivityPoster(receivers, parentComment.getPosterId(), comment.getPosterId());
            } else {
                Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId());
                Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
                Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId());
                receivers.remove(parentCommentUserPosterId);
            }
        } else {
            Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId());
            Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
            Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId());
        }
        return NotificationInfo.instance().to(new ArrayList<String>(receivers)).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId()).with(SocialNotificationUtils.POSTER.getKey(), Utils.getUserId(comment.getUserId())).key(this.getId());
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        if (this.isSubComment && comment.getParentCommentId() == null) {
            return false;
        }
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

