/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class LikeWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        LikeWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        LikeWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikePlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"LikePlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"LikePlugin"));
    }

    public void testLikeActivity() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.activityManager.saveLike(activity, this.demoIdentity);
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "likes your activity");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "\"");
    }

    public void testLikeAndDislikeActivity() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.makeComment(activity, this.demoIdentity, "demo post a comment");
        this.assertMadeWebNotifications(0);
        this.makeComment(activity, this.maryIdentity, "mary post a comment");
        this.assertMadeWebNotifications(0);
        this.activityManager.saveLike(activity, this.demoIdentity);
        this.assertMadeWebNotifications(1);
        this.assertMadeWebNotifications(this.maryIdentity.getRemoteId(), 0);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "likes your activity");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "\"");
        this.activityManager.saveLike(activity, this.maryIdentity);
        this.assertMadeWebNotifications(2);
        this.assertMadeWebNotifications(this.demoIdentity.getRemoteId(), 0);
        list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 2);
        likeNotification = list.get(1);
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, "likes your activity");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "\"");
        this.activityManager.deleteLike(activity, this.demoIdentity);
        this.assertMadeWebNotifications(2);
        this.activityManager.deleteLike(activity, this.maryIdentity);
        this.assertMadeWebNotifications(2);
    }
}

