/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityPluginType;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.Utils;

public class LinkProviderUtils {
    public static final String RESOURCE_URL = "social/notifications";
    public static final String INVITE_TO_CONNECT = "social/notifications/inviteToConnect";
    public static final String CONFIRM_INVITATION_TO_CONNECT = "social/notifications/confirmInvitationToConnect";
    public static final String IGNORE_INVITATION_TO_CONNECT = "social/notifications/ignoreInvitationToConnect";
    public static final String ACCEPT_INVITATION_JOIN_SPACE = "social/notifications/acceptInvitationToJoinSpace";
    public static final String IGNORE_INVITATION_JOIN_SPACE = "social/notifications/ignoreInvitationToJoinSpace";
    public static final String VALIDATE_REQUEST_JOIN_SPACE = "social/notifications/validateRequestToJoinSpace";
    public static final String REFUSE_SPACE_REQUEST_ACTION = "social/notifications/refuseRequestToJoinSpace";
    public static final String REPLY_ACTIVITY = "social/notifications/replyActivity";
    public static final String VIEW_FULL_DISCUSSION = "social/notifications/viewFullDiscussion";
    public static final String REDIRECT_URL = "social/notifications/redirectUrl";
    public static final String PRIVATE_PATH = "/private";
    private static final String COLLABORATION_WS = "collaboration";
    public static final String LOGIN_INITIALURI = "/login?initialURI=/";
    private static final Log LOG = ExoLogger.getLogger(LinkProviderUtils.class);

    public static String getInviteToConnectUrl(String receiverId, String senderId) {
        return LinkProviderUtils.getRestUrl(INVITE_TO_CONNECT, receiverId, senderId);
    }

    public static String getConfirmInvitationToConnectUrl(String senderId, String receiverId) {
        return LinkProviderUtils.getPortalRestUrl(CONFIRM_INVITATION_TO_CONNECT, senderId, receiverId);
    }

    public static String getIgnoreInvitationToConnectUrl(String senderId, String receiverId) {
        return LinkProviderUtils.getPortalRestUrl(IGNORE_INVITATION_TO_CONNECT, senderId, receiverId);
    }

    public static String getAcceptInvitationToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getPortalRestUrl(ACCEPT_INVITATION_JOIN_SPACE, spaceId, userId);
    }

    public static String getIgnoreInvitationToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getPortalRestUrl(IGNORE_INVITATION_JOIN_SPACE, spaceId, userId);
    }

    public static String getValidateRequestToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getPortalRestUrl(VALIDATE_REQUEST_JOIN_SPACE, spaceId, userId);
    }

    public static String getRefuseRequestToJoinSpaceUrl(String spaceId, String userId) {
        return LinkProviderUtils.getPortalRestUrl(REFUSE_SPACE_REQUEST_ACTION, spaceId, userId);
    }

    public static String getRedirectUrl(String type, String objectId) {
        return LinkProviderUtils.getRestUrl(REDIRECT_URL, type, objectId);
    }

    public static String getWebNotificationRestUrl(String type, String objectId1, String objectId2) {
        String restContext = CommonsUtils.getRestContextName();
        return new StringBuffer("/").append(restContext).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).toString();
    }

    public static String getWebNotificationRestUrl(String type, String objectId1, String objectId2, String notificationId, String jsonFile) {
        String restContext = CommonsUtils.getRestContextName();
        return new StringBuffer("/").append(restContext).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).append("/").append(notificationId).append("/").append(jsonFile).toString();
    }

    public static String getRestUrl(String type, String objectId1, String objectId2) {
        String baseUrl = LinkProviderUtils.getBaseRestUrl();
        return new StringBuffer(baseUrl).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).toString();
    }

    public static String getBaseRestUrl() {
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    public static String getPortalRestUrl(String type, String objectId1, String objectId2) {
        String baseUrl = LinkProviderUtils.getPortalLoginRedirectURL();
        return new StringBuffer(baseUrl).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).toString();
    }

    public static String getPortalLoginRedirectURL() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(portal).append(LOGIN_INITIALURI).append(portal).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    @Deprecated
    public static String getPrivateRestUrl(String type, String objectId1, String objectId2) {
        String baseUrl = LinkProviderUtils.getBasePrivateRestUrl();
        return new StringBuffer(baseUrl).append("/").append(type).append("/").append(objectId1).append("/").append(objectId2).toString();
    }

    public static String getBasePrivateRestUrl() {
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(CommonsUtils.getRestContextName()).append(PRIVATE_PATH).toString();
    }

    public static String getUserAvatarUrl(Profile profile) {
        return CommonsUtils.getCurrentDomain() + (profile != null && profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png");
    }

    public static String getSpaceAvatarUrl(Space space) {
        return CommonsUtils.getCurrentDomain() + (space != null && space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getOpenLink(ExoSocialActivity activity) {
        String activityType = activity.getType();
        if (activityType != null) {
            try {
                Map templateParams = activity.getTemplateParams();
                if (activityType.equals(ActivityPluginType.WIKI.getName())) {
                    return CommonsUtils.getCurrentDomain() + (String)templateParams.get("page_url");
                }
                if (activityType.equals(ActivityPluginType.FORUM.getName())) {
                    if (!activity.isComment()) return CommonsUtils.getCurrentDomain() + (String)templateParams.get("TopicLink");
                    if (activity.getTitleId().equals("forum.remove-poll")) return null;
                    if (!activity.getTitleId().equals("forum.add-poll")) return (String)templateParams.get("PostLink");
                    return LinkProviderUtils.getOpenLink(Utils.getActivityManager().getParentActivity(activity));
                }
                if (activityType.equals(ActivityPluginType.CALENDAR.getName())) {
                    return CommonsUtils.getCurrentDomain() + (String)templateParams.get("EventLink");
                }
                if (activityType.contains(ActivityPluginType.ANSWER.getName())) {
                    if (!activity.isComment()) return (String)templateParams.get("Link");
                    return (String)Utils.getActivityManager().getParentActivity(activity).getTemplateParams().get("Link");
                }
                if (activityType.equals(ActivityPluginType.POLL.getName())) {
                    return CommonsUtils.getCurrentDomain() + (String)templateParams.get("Link");
                }
                if (activityType.equals(ActivityPluginType.SHARE_FILE.getName()) || activityType.equals(ActivityPluginType.CONTENT.getName())) {
                    String contenLink = (String)templateParams.get("contenLink");
                    String[] contentLinks = contenLink.split("\\|@\\|");
                    if (contentLinks.length <= 1) return CommonsUtils.getCurrentDomain() + contenLink;
                    contenLink = contentLinks[0];
                    return CommonsUtils.getCurrentDomain() + contenLink;
                }
                if (activityType.equals(ActivityPluginType.FILE.getName())) {
                    return null;
                }
                if (activity.isComment() && activityType.contains("answer:")) {
                    return (String)Utils.getActivityManager().getParentActivity(activity).getTemplateParams().get("Link");
                }
                if (!activity.isComment()) return null;
                return LinkProviderUtils.getOpenLink(Utils.getActivityManager().getParentActivity(activity));
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot get open link for activity " + activity.getId() + " : " + e.getMessage()), (Throwable)e);
                return null;
            }
        } else {
            String type;
            if (!activity.isComment() || (type = Utils.getActivityManager().getParentActivity(activity).getType()) == null || !type.equals(ActivityPluginType.ANSWER.getName())) return null;
            return (String)Utils.getActivityManager().getParentActivity(activity).getTemplateParams().get("Link");
        }
    }

    public static String getQuarantineRedirectURL(String username) {
        String portal = PortalContainer.getCurrentPortalContainerName();
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(portal).append("/").append("g/:platform:dlp/dlp-quarantine").toString();
    }

    public static String getMfaAdminURL() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        return CommonsUtils.getCurrentDomain() + "/" + portal + "/g/:platform:administrators/multifactor-authentication";
    }

    public static String getDlpRestoredUrl(String reference) {
        return LinkProviderUtils.getBasePrivateRestUrl() + "/documents/view/collaboration/" + reference;
    }
}

