/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.Utils;

public abstract class AbstractPluginTest
extends AbstractCoreTest {
    protected Locale initialDefaultLocale;
    protected UserSettingService userSettingService;

    public abstract BaseNotificationPlugin getPlugin();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.userSettingService = (UserSettingService)Utils.getService(UserSettingService.class);
        this.initialDefaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        this.initUserSetting();
        this.turnON(this.getPlugin());
    }

    @Override
    protected void tearDown() throws Exception {
        this.turnOFF(this.getPlugin());
        if (this.initialDefaultLocale != null) {
            Locale.setDefault(this.initialDefaultLocale);
        }
        super.tearDown();
    }

    public void destroyPlugins(BaseNotificationPlugin plugin) {
        plugin = null;
    }

    protected NotificationInfo getNotificationInfo(String username) {
        List<NotificationInfo> list = this.notificationService.storeDigest(username);
        AbstractPluginTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        return list.get(0);
    }

    protected List<NotificationInfo> getNotificationInfos(String username) {
        return this.notificationService.storeDigest(username);
    }

    protected void assertSubject(MessageInfo message, String validatedString) {
        AbstractPluginTest.assertEquals((String)validatedString, (String)message.getSubject());
    }

    protected void assertBody(MessageInfo message, String includedString) {
        AbstractPluginTest.assertTrue((String)("body = '" + message.getBody() + "' \r\n doesn't contain\r\n " + includedString), (message.getBody().indexOf(includedString) > 0 ? 1 : 0) != 0);
    }

    protected void assertDigest(Writer writer, String includedString) {
        AbstractPluginTest.assertEquals((String)includedString, (String)writer.toString().replaceAll("\\<.*?>", ""));
    }

    protected void assertMadeMailDigestNotifications(int number) {
        UserSetting setting = this.userSettingService.get(this.rootIdentity.getRemoteId());
        if (setting.isInDaily(this.getPlugin().getKey().getId())) {
            AbstractPluginTest.assertEquals((int)number, (int)this.notificationService.sizeOfStoredDigest());
        }
    }

    protected List<NotificationInfo> assertMadeMailDigestNotifications(String username, int number) {
        UserSetting setting = this.userSettingService.get(username);
        List<NotificationInfo> got = this.notificationService.storeDigest(username);
        if (setting.isActive(UserSetting.EMAIL_CHANNEL, this.getPlugin().getKey().getId())) {
            got = this.notificationService.storeInstantly(username);
            AbstractPluginTest.assertEquals((int)number, (int)got.size());
        }
        return got;
    }

    protected void assertMadeWebNotifications(int number) {
        UserSetting setting = this.userSettingService.get(this.rootIdentity.getRemoteId());
        if (setting.isActive("WEB_CHANNEL", this.getPlugin().getKey().getId())) {
            AbstractPluginTest.assertEquals((int)number, (int)this.notificationService.sizeOfWebNotifs());
        }
    }

    protected List<NotificationInfo> assertMadeWebNotifications(String username, int number) {
        UserSetting setting = this.userSettingService.get(username);
        List<NotificationInfo> got = this.notificationService.storeWebNotifs(username);
        if (setting.isActive("WEB_CHANNEL", this.getPlugin().getKey().getId())) {
            got = this.notificationService.storeWebNotifs(username);
            AbstractPluginTest.assertEquals((int)number, (int)got.size());
        }
        return got;
    }

    protected void turnON(BaseNotificationPlugin plugin) {
        this.pluginSettingService.saveActivePlugin(UserSetting.EMAIL_CHANNEL, plugin.getId(), true);
    }

    protected void turnFeatureOn() {
        this.exoFeatureService.saveActiveFeature("notification", true);
    }

    protected void turnFeatureOff() {
        this.exoFeatureService.saveActiveFeature("notification", false);
    }

    protected void turnOFF(BaseNotificationPlugin plugin) {
        this.pluginSettingService.saveActivePlugin(UserSetting.EMAIL_CHANNEL, plugin.getId(), false);
    }

    protected Relationship makeRelationship(Identity identity1, Identity identity2) {
        Relationship relationship = this.relationshipManager.inviteToConnect(identity1, identity2);
        this.tearDownRelationshipList.add(relationship);
        return relationship;
    }

    protected void cancelRelationship(Identity identity1, Identity identity2) {
        Relationship relationship = this.relationshipManager.get(identity1, identity2);
        if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
            this.relationshipManager.delete(relationship);
            this.tearDownRelationshipList.remove(relationship);
        }
    }

    protected ExoSocialActivity makeCommentReply(ExoSocialActivity activity, Identity commenter, String commentTitle, String parentCommentId) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(commenter.getId());
        comment.setParentCommentId(parentCommentId);
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        return comment;
    }

    protected ExoSocialActivity makeComment(ExoSocialActivity activity, Identity commenter, String commentTitle) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(commenter.getId());
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        return comment;
    }

    protected ExoSocialActivity editComment(ExoSocialActivity activity, ExoSocialActivity comment, String commentTitle) {
        comment.setTitle(commentTitle);
        this.activityManager.saveComment(activity, comment);
        return comment;
    }

    protected Space getSpaceInstance(int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setAvatarUrl("my-avatar-url");
        String[] managers = new String[]{this.rootIdentity.getRemoteId()};
        String[] members = new String[]{this.rootIdentity.getRemoteId()};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceService.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        return space;
    }

    protected void setInstantlySettings(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive(UserSetting.EMAIL_CHANNEL);
        userSetting.setChannelPlugins(UserSetting.EMAIL_CHANNEL, settings);
        this.userSettingService.save(userSetting);
    }

    protected void setDailySetting(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive(UserSetting.EMAIL_CHANNEL);
        userSetting.setDailyPlugins(settings);
        this.userSettingService.save(userSetting);
    }

    protected void setWeeklySetting(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive(UserSetting.EMAIL_CHANNEL);
        userSetting.setWeeklyPlugins(settings);
        this.userSettingService.save(userSetting);
    }

    private void initUserSetting() {
        ArrayList<String> instantly = new ArrayList<String>();
        instantly.add("PostActivityPlugin");
        instantly.add("ActivityCommentPlugin");
        instantly.add("ActivityReplyToCommentPlugin");
        instantly.add("ActivityMentionPlugin");
        instantly.add("LikePlugin");
        instantly.add("EditCommentPlugin");
        instantly.add("EditActivityPlugin");
        instantly.add("LikeCommentPlugin");
        instantly.add("RequestJoinSpacePlugin");
        instantly.add("SpaceInvitationPlugin");
        instantly.add("RelationshipReceivedRequestPlugin");
        instantly.add("PostActivitySpaceStreamPlugin");
        instantly.add("DlpUserDetectedItemPlugin");
        instantly.add("DlpAdminDetectedItemPlugin");
        instantly.add("DlpUserRestoredItemPlugin");
        instantly.add("MalwareDetectionPlugin");
        ArrayList<String> daily = new ArrayList<String>();
        daily.add("PostActivityPlugin");
        daily.add("ActivityCommentPlugin");
        daily.add("ActivityReplyToCommentPlugin");
        daily.add("ActivityMentionPlugin");
        daily.add("LikePlugin");
        daily.add("EditActivityPlugin");
        daily.add("EditCommentPlugin");
        daily.add("RequestJoinSpacePlugin");
        daily.add("SpaceInvitationPlugin");
        daily.add("RelationshipReceivedRequestPlugin");
        daily.add("PostActivitySpaceStreamPlugin");
        daily.add("NewUserPlugin");
        ArrayList<String> weekly = new ArrayList<String>();
        weekly.add("PostActivityPlugin");
        weekly.add("ActivityCommentPlugin");
        daily.add("ActivityReplyToCommentPlugin");
        weekly.add("ActivityMentionPlugin");
        weekly.add("LikePlugin");
        weekly.add("EditCommentPlugin");
        weekly.add("EditActivityPlugin");
        weekly.add("RequestJoinSpacePlugin");
        weekly.add("SpaceInvitationPlugin");
        weekly.add("RelationshipReceivedRequestPlugin");
        weekly.add("PostActivitySpaceStreamPlugin");
        ArrayList<String> webNotifs = new ArrayList<String>();
        webNotifs.add("NewUserPlugin");
        webNotifs.add("PostActivityPlugin");
        webNotifs.add("ActivityCommentPlugin");
        webNotifs.add("ActivityReplyToCommentPlugin");
        webNotifs.add("ActivityMentionPlugin");
        webNotifs.add("LikePlugin");
        webNotifs.add("EditActivityPlugin");
        webNotifs.add("EditCommentPlugin");
        webNotifs.add("LikeCommentPlugin");
        webNotifs.add("RequestJoinSpacePlugin");
        webNotifs.add("SpaceInvitationPlugin");
        webNotifs.add("RelationshipReceivedRequestPlugin");
        webNotifs.add("PostActivitySpaceStreamPlugin");
        webNotifs.add("DlpUserDetectedItemPlugin");
        webNotifs.add("DlpAdminDetectedItemPlugin");
        webNotifs.add("DlpUserRestoredItemPlugin");
        webNotifs.add("MalwareDetectionPlugin");
        this.saveSetting(instantly, daily, weekly, webNotifs, this.rootIdentity.getRemoteId());
        this.saveSetting(instantly, daily, weekly, webNotifs, this.maryIdentity.getRemoteId());
        this.saveSetting(instantly, daily, weekly, webNotifs, this.johnIdentity.getRemoteId());
        this.saveSetting(instantly, daily, weekly, webNotifs, this.demoIdentity.getRemoteId());
    }

    private void saveSetting(List<String> instantly, List<String> daily, List<String> weekly, List<String> webNotifs, String userId) {
        UserSetting model = UserSetting.getInstance();
        model.setUserId(userId).setChannelActive(UserSetting.EMAIL_CHANNEL);
        model.setChannelPlugins(UserSetting.EMAIL_CHANNEL, instantly);
        model.setDailyPlugins(daily);
        model.setWeeklyPlugins(weekly);
        model.setChannelPlugins("WEB_CHANNEL", webNotifs);
        this.userSettingService.save(model);
    }

    protected AbstractTemplateBuilder getTemplateBuilder(NotificationContext ctx) {
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        AbstractPluginTest.assertNotNull((Object)channel);
        return channel.getTemplateBuilder(ctx.getNotificationInfo().getKey());
    }

    protected MessageInfo buildMessageInfo(NotificationContext ctx) {
        AbstractTemplateBuilder templateBuilder = this.getTemplateBuilder();
        if (templateBuilder == null) {
            templateBuilder = this.getTemplateBuilder(ctx);
        }
        MessageInfo massage = templateBuilder.buildMessage(ctx);
        AbstractPluginTest.assertNotNull((Object)massage);
        return massage;
    }

    protected void buildDigest(NotificationContext ctx, Writer writer) {
        AbstractTemplateBuilder templateBuilder = this.getTemplateBuilder();
        if (templateBuilder == null) {
            templateBuilder = this.getTemplateBuilder(ctx);
        }
        templateBuilder.buildDigest(ctx, writer);
    }

    public abstract AbstractTemplateBuilder getTemplateBuilder();
}

