/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.dlp.dto.DlpPositiveItem;
import org.exoplatform.commons.dlp.service.DlpPositiveItemService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class DlpAdminDetectedItemPlugin
extends BaseNotificationPlugin {
    public static final String ID = "DlpAdminDetectedItemPlugin";
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpAdminDetectedItemPlugin.class);
    private DlpPositiveItemService dlpPositiveItemService;
    private OrganizationService organizationService;
    private UserACL userACL;

    public DlpAdminDetectedItemPlugin(InitParams initParams, DlpPositiveItemService dlpPositiveItemService, OrganizationService organizationService, UserACL userACL) {
        super(initParams);
        this.dlpPositiveItemService = dlpPositiveItemService;
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        long dlpItemId = (Long)ctx.value(SocialNotificationUtils.DLP_DETECTED_ITEM_ID);
        DlpPositiveItem dlpPositiveItem = null;
        try {
            dlpPositiveItem = this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(dlpItemId));
            return NotificationInfo.instance().key(this.getId()).with("itemTitle", dlpPositiveItem.getTitle()).to(this.getRecipients());
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    private List<String> getRecipients() {
        ArrayList<String> members = new ArrayList<String>();
        try {
            ListAccess dlpMembersAccess = this.organizationService.getUserHandler().findUsersByGroupId(this.userACL.getDlpGroups());
            int totalAdminGroupMembersSize = dlpMembersAccess.getSize();
            User[] users = (User[])dlpMembersAccess.load(0, totalAdminGroupMembersSize);
            return Arrays.stream(users).map(User::getUserName).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error when getting DLP group members");
            return members;
        }
    }
}

