/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivityCommentWebBuilderTest
extends AbstractPluginTest {
    private static final String ACTIVITY_TITLE = "my activity's title post today.";
    private static final String COMMENT_TITLE = "my comment's title add today.";
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        ActivityCommentWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivityCommentWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityCommentPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeWebNotifications(1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.demoIdentity, COMMENT_TITLE);
        this.assertMadeWebNotifications(2);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 2);
        NotificationInfo commentNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has commented on your activity");
        this.assertBody(info, ACTIVITY_TITLE);
    }
}

