/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.commons.dlp.dto.DlpPositiveItem;
import org.exoplatform.commons.dlp.service.DlpPositiveItemService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.notification.AbstractPluginTest;

public class DlpUserRestoredItemWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        DlpUserRestoredItemWebBuilderTest.assertNotNull((Object)channel);
        DlpUserRestoredItemWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"DlpUserRestoredItemPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"DlpUserRestoredItemPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"DlpUserRestoredItemPlugin"));
    }

    public void testSimpleCase() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        DlpPositiveItemService dlpPositiveItemService = (DlpPositiveItemService)container.getComponentInstanceOfType(DlpPositiveItemService.class);
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity.setReference("file1234");
        dlpPositiveItemEntity.setTitle("file1");
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setAuthor(this.maryIdentity.getRemoteId());
        dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity);
        DlpPositiveItem dlpPositiveItem = dlpPositiveItemService.getDlpPositiveItemByReference("file1234");
        dlpPositiveItemService.restoreDlpPositiveItem(dlpPositiveItem.getId());
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.maryIdentity.getRemoteId(), 1);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(list.get(0).setTo(this.rootIdentity.getRemoteId()));
        MessageInfo message = this.buildMessageInfo(ctx);
        this.assertBody(message, "has been analyzed during a quarantine phase. It has been validated and restored in his initial location");
    }
}

