/*
 * Copyright (C) 2020 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.service.malwareDetection.connector.MalwareDetectionItemConnector;

public class MalwareDetectionPlugin extends BaseNotificationPlugin {

  public static final String ID = "MalwareDetectionPlugin";

  public MalwareDetectionPlugin(InitParams initParams) {
    super(initParams);
  }

  @Override
  public String getId() {
    return ID;
  }

  @Override
  public NotificationInfo makeNotification(NotificationContext ctx) {
    String infectedItemName = ctx.value(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT);
    String infectedItemLastModifier = ctx.value(MalwareDetectionItemConnector.INFECTED_ITEM_LAST_MODIFIER_ARGUMENT);
    NotificationInfo notificationInfo = NotificationInfo.instance().key(getId());
    notificationInfo.with(MalwareDetectionItemConnector.INFECTED_ITEM_NAME, infectedItemName);
    notificationInfo.to(infectedItemLastModifier);
    return notificationInfo;
  }

  @Override
  public boolean isValid(NotificationContext ctx) {
    return true;
  }
}
