/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class NewUserMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
        NewUserMailBuilderTest.assertTrue((boolean)this.pluginSettingService.isActive(this.getPlugin().getId()));
        NewUserMailBuilderTest.assertTrue((boolean)this.exoFeatureService.isActiveFeature("notification"));
        this.notificationService.clearAll();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        NewUserMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        NewUserMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"NewUserPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"NewUserPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"NewUserPlugin"));
    }

    public void testSimpleCase() throws Exception {
        this.createUser("user_1");
        this.assertMadeMailDigestNotifications(4);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 4);
        NotificationInfo newUserNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(newUserNotification.setTo("mary"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, "USER_1 gtn has joined eXo");
        this.assertBody(info, "New user on eXo");
        this.removeUser("user_1");
    }

    public void testPluginONOFF() throws Exception {
        this.createUser("user_11");
        this.assertMadeMailDigestNotifications(4);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        this.notificationService.clearAll();
        this.removeUser("user_11");
        this.turnOFF(this.getPlugin());
        this.createUser("user_12");
        this.assertMadeMailDigestNotifications(0);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 0);
        this.removeUser("user_12");
        this.turnON(this.getPlugin());
        this.createUser("user_123");
        this.assertMadeMailDigestNotifications(4);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        this.notificationService.clearAll();
        this.removeUser("user_123");
    }

    public void testFeatureONOFF() throws Exception {
        this.createUser("user_13");
        this.assertMadeMailDigestNotifications(4);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        this.notificationService.clearAll();
        this.removeUser("user_13");
        this.turnFeatureOff();
        this.createUser("user_23");
        this.assertMadeMailDigestNotifications(0);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 0);
        this.removeUser("user_23");
        this.turnFeatureOn();
        this.createUser("user_234");
        this.assertMadeMailDigestNotifications(4);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        this.notificationService.clearAll();
        this.removeUser("user_234");
    }

    public void testDigest() throws Exception {
        this.createUser("user_111");
        this.createUser("user_222");
        this.createUser("user_333");
        this.assertMadeMailDigestNotifications(12);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list = new ArrayList<NotificationInfo>(new LinkedHashSet<NotificationInfo>(list));
        list.get(0).setTo(this.rootIdentity.getRemoteId());
        this.removeUser("user_111");
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "USER_222 gtn, USER_333 gtn have joined eXo.");
        this.removeUser("user_222");
        this.removeUser("user_333");
    }

    private void createUser(String userName) throws Exception {
        UserHandler userHandler = this.getUserHandler();
        User user = userHandler.createUserInstance(userName);
        user.setEmail(userName + "@plf.com");
        user.setFirstName(userName.toUpperCase());
        user.setLastName("gtn");
        user.setPassword("exo");
        userHandler.createUser(user, true);
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userName, true);
        this.tearDownIdentityList.add(identity);
    }

    private UserHandler getUserHandler() {
        UserHandler userHandler = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler();
        return userHandler;
    }

    private void removeUser(String userName) throws Exception {
        UserHandler userHandler = this.getUserHandler();
        userHandler.removeUser(userName, true);
    }
}

