/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class EditActivityWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        EditActivityWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        EditActivityWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditActivityPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"EditActivityPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"EditActivityPlugin"));
    }

    public void testEditActivity() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.makeComment(activity, this.demoIdentity, "comment");
        activity.setTitle("edited activity");
        this.activityManager.updateActivity(activity);
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.demoIdentity.getRemoteId(), 1);
        NotificationInfo editNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(editNotification.setTo("demo"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "edited activity");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "\"");
    }
}

