/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.Utils;

public class UtilsTestCase
extends AbstractCoreTest {
    Space space;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.space = new Space();
        this.space.setDisplayName("my space");
        this.space.setPrettyName(this.space.getDisplayName());
        this.space.setRegistration("open");
        this.space.setDescription("new space ");
        this.space.setType("classic");
        this.space.setVisibility("public");
        this.space.setRegistration("validation");
        this.space.setPriority("2");
        this.space.setGroupId("/space/space");
        String[] managers = new String[]{this.rootIdentity.getRemoteId()};
        String[] members = new String[]{this.rootIdentity.getRemoteId(), this.demoIdentity.getRemoteId(), this.johnIdentity.getRemoteId()};
        this.space.setManagers(managers);
        this.space.setMembers(members);
        this.space.setUrl(this.space.getPrettyName());
        this.space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.space = this.spaceService.createSpace(this.space, this.rootIdentity.getRemoteId());
        this.tearDownSpaceList.add(this.space);
        System.setProperty("gatein.email.domain.url", "http://exoplatform.com");
    }

    public void testProcessLinkInActivityTitle() throws Exception {
        String title = "<a href=\"www.yahoo.com\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\">Hotmail Site</a>";
        title = Utils.processLinkTitle((String)title);
        UtilsTestCase.assertEquals((String)"<a href=\"www.yahoo.com\" style=\"color: #2f5e92; text-decoration: none;\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\" style=\"color: #2f5e92; text-decoration: none;\">Hotmail Site</a>", (String)title);
        title = "Shared a document <a href=\"portal/rest/Do_Thanh_Tung/Public/New+design.+eXo+in+Smart+Watch.jpg\">New design. eXo in Smart Watch.jpg</a>";
        UtilsTestCase.assertEquals((String)"Shared a document <a href=\"http://exoplatform.com/portal/rest/Do_Thanh_Tung/Public/New+design.+eXo+in+Smart+Watch.jpg\" style=\"color: #2f5e92; text-decoration: none;\">New design. eXo in Smart Watch.jpg</a>", (String)Utils.processLinkTitle((String)title));
        title = "Shared a document <a href=\"/portal/rest/Do_Thanh_Tung/Public/New+design.+eXo+in+Smart+Watch.jpg\">New design. eXo in Smart Watch.jpg</a>";
        UtilsTestCase.assertEquals((String)"Shared a document <a href=\"http://exoplatform.com/portal/rest/Do_Thanh_Tung/Public/New+design.+eXo+in+Smart+Watch.jpg\" style=\"color: #2f5e92; text-decoration: none;\">New design. eXo in Smart Watch.jpg</a>", (String)Utils.processLinkTitle((String)title));
    }

    public void testGetMentioners() {
        String mentionTitle = "<a href=\"/portal/dw/profile/demo\"> " + this.demoIdentity.getProfile().getFullName() + " </a>";
        Set receivers = Utils.getMentioners((String)mentionTitle, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)1, (int)receivers.size());
        mentionTitle = "<a href=\"/portal/dw/profile/root\"> " + this.rootIdentity.getProfile().getFullName() + " </a>";
        receivers = Utils.getMentioners((String)mentionTitle, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
        mentionTitle = "<a href=\"/portal/dw/profile/ghost\"> " + this.ghostIdentity.getProfile().getFullName() + " </a>";
        receivers = Utils.getMentioners((String)mentionTitle, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
    }

    public void testSendToCommenters() {
        HashSet receivers = new HashSet();
        String[] commenters = new String[]{this.demoIdentity.getId()};
        Utils.sendToCommeters(receivers, (String[])commenters, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)1, (int)receivers.size());
        receivers = new HashSet();
        commenters = new String[]{this.rootIdentity.getId()};
        Utils.sendToCommeters(receivers, (String[])commenters, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
        receivers = new HashSet();
        commenters = new String[]{this.ghostIdentity.getId()};
        Utils.sendToCommeters(receivers, (String[])commenters, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
    }

    public void testSendToLikers() {
        HashSet receivers = new HashSet();
        String[] likers = new String[]{this.demoIdentity.getId()};
        Utils.sendToLikers(receivers, (String[])likers, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)1, (int)receivers.size());
        receivers = new HashSet();
        likers = new String[]{this.rootIdentity.getId()};
        Utils.sendToLikers(receivers, (String[])likers, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
        receivers = new HashSet();
        likers = new String[]{this.ghostIdentity.getId()};
        Utils.sendToLikers(receivers, (String[])likers, (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
    }

    public void testSendToActivityPoster() {
        HashSet receivers = new HashSet();
        Utils.sendToActivityPoster(receivers, (String)this.demoIdentity.getId(), (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)1, (int)receivers.size());
        receivers = new HashSet();
        Utils.sendToActivityPoster(receivers, (String)this.rootIdentity.getId(), (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
        receivers = new HashSet();
        Utils.sendToActivityPoster(receivers, (String)this.ghostIdentity.getId(), (String)this.rootIdentity.getId(), (String)this.space.getId());
        UtilsTestCase.assertEquals((int)0, (int)receivers.size());
    }
}

