/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManagerImpl;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.mock.MockNotificationService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.notification-dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.notification-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.notification-local-configuration.xml")})
public abstract class AbstractCoreTest
extends BaseExoTestCase {
    protected IdentityManager identityManager;
    protected ActivityManagerImpl activityManager;
    protected SpaceService spaceService;
    protected RelationshipManagerImpl relationshipManager;
    protected PluginContainer pluginService;
    protected MockNotificationService notificationService;
    protected PluginSettingService pluginSettingService;
    protected ExoFeatureService exoFeatureService;
    protected OrganizationService organizationService;
    protected Identity rootIdentity;
    protected Identity johnIdentity;
    protected Identity maryIdentity;
    protected Identity demoIdentity;
    protected Identity ghostIdentity;
    protected List<ExoSocialActivity> tearDownActivityList;
    protected List<Space> tearDownSpaceList;
    protected List<Identity> tearDownIdentityList;
    protected List<Relationship> tearDownRelationshipList;

    protected void setUp() throws Exception {
        this.begin();
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownSpaceList = new ArrayList<Space>();
        this.tearDownIdentityList = new ArrayList<Identity>();
        this.tearDownRelationshipList = new ArrayList<Relationship>();
        this.identityManager = this.getService(IdentityManager.class);
        this.activityManager = this.getService(ActivityManagerImpl.class);
        this.spaceService = this.getService(SpaceService.class);
        this.relationshipManager = this.getService(RelationshipManagerImpl.class);
        this.pluginService = this.getService(PluginContainer.class);
        this.notificationService = this.getService(MockNotificationService.class);
        this.pluginSettingService = this.getService(PluginSettingService.class);
        this.exoFeatureService = this.getService(ExoFeatureService.class);
        this.organizationService = this.getService(OrganizationService.class);
        System.setProperty("gatein.email.domain.url", "http://exoplatform.com");
        this.checkAndCreateDefaultUsers();
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo");
        this.ghostIdentity = this.identityManager.getOrCreateIdentity("organization", "ghost");
        this.notificationService.clearAll();
    }

    protected void tearDown() throws Exception {
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityManager.deleteActivity(activity.getId());
        }
        for (Space sp : this.tearDownSpaceList) {
            this.spaceService.deleteSpace(sp);
        }
        for (Relationship relationship : this.tearDownRelationshipList) {
            this.relationshipManager.remove(relationship);
        }
        for (Identity identity : this.tearDownIdentityList) {
            this.identityManager.deleteIdentity(identity);
        }
        this.notificationService.clearAll();
        this.end();
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    private void checkAndCreateDefaultUsers() {
        UserHandler handler = this.getService(OrganizationService.class).getUserHandler();
        String[] users = new String[]{"root", "demo", "mary", "john", "ghost"};
        try {
            for (String userName : users) {
                if (handler.findUserByName(userName) == null) {
                    User user = handler.createUserInstance(userName);
                    user.setPassword(userName);
                    user.setFirstName(userName);
                    user.setLastName(userName);
                    user.setEmail(userName + "@plf.com");
                    handler.createUser(user, true);
                }
                handler.setEnabled(userName, true, true);
            }
        }
        catch (Exception e) {
            ExoLogger.getExoLogger(((Object)((Object)this)).getClass()).debug((Object)e);
        }
    }

    protected void runTest() throws Throwable {
        String fName = this.getName();
        AbstractCoreTest.assertNotNull((String)"TestCase.fName cannot be null", (Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, null);
        }
        catch (NoSuchMethodException e) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" should be public"));
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    protected ExoSocialActivity makeActivity(Identity owner, String activityTitle) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(owner.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        return activity;
    }

    protected ExoSocialActivity makeActivityOnStream(Identity owner, String activityTitle) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(owner.getId());
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        return activity;
    }

    protected ExoSocialActivity editActivity(ExoSocialActivity activity, String activityTitle) {
        activity.setTitle(activityTitle);
        this.activityManager.updateActivity(activity);
        return activity;
    }

    protected String getFullName(String userId) {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
        AbstractCoreTest.assertNotNull((String)("Can't find identity of " + userId), (Object)identity);
        AbstractCoreTest.assertNotNull((String)("Can't find profile of " + userId), (Object)identity.getProfile());
        return identity.getProfile().getFullName();
    }
}

