/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.rest;

import io.meeds.social.notification.rest.NotificationSettingsRestService;
import io.meeds.social.notification.rest.model.UserNotificationSettings;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;
import org.exoplatform.social.service.rest.BaseRestServicesTestCase;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class NotificationSettingsRestServiceTest
extends BaseRestServicesTestCase {
    private static final String USER_1 = "testuser1";
    private static final String USER_2 = "testuser2";
    private static final String CHANNEL_ID = "channelId";
    private static final String GROUP_PROVIDER_ID = "groupId";
    private static final String PLUGIN_ID = "pluginId";
    private static final PluginInfo PLUGIN_PROVIDER = new PluginInfo();
    private static final PluginConfig PLUGIN_CONFIG = new PluginConfig();
    private static final List<PluginInfo> PLUGINS;
    private static final GroupProvider GROUP_PROVIDER;
    private static final List<GroupProvider> GROUPS;
    private static final List<GroupProvider> EMPTY_GROUP_PROVIDER;
    private static final List<AbstractChannel> CHANNELS;
    private ChannelManager channelManager;
    private UserSettingService userSettingService;
    private UserACL userACL;
    private PluginSettingService pluginSettingService;

    protected Class<?> getComponentClass() {
        return NotificationSettingsRestService.class;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pluginSettingService = (PluginSettingService)Mockito.mock(PluginSettingService.class);
        this.channelManager = (ChannelManager)Mockito.mock(ChannelManager.class);
        this.userSettingService = (UserSettingService)Mockito.mock(UserSettingService.class);
        this.userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)this.userACL.isSuperUser()).thenReturn((Object)false);
        Mockito.when((Object)this.userACL.getAdminGroups()).thenReturn((Object)"admins");
        Mockito.when((Object)this.channelManager.getChannels()).thenReturn(CHANNELS);
        Mockito.when((Object)this.pluginSettingService.getGroupPlugins()).thenReturn(GROUPS);
        Mockito.when((Object)this.pluginSettingService.getPluginConfig((String)ArgumentMatchers.eq((Object)PLUGIN_ID))).thenReturn((Object)PLUGIN_CONFIG);
        Mockito.when((Object)this.pluginSettingService.isChannelActive(CHANNEL_ID)).thenReturn((Object)true);
        UserSetting userSetting = new UserSetting();
        userSetting.setChannelActive(CHANNEL_ID);
        userSetting.setEnabled(true);
        userSetting.setUserId(USER_1);
        userSetting.setChannelPlugins(CHANNEL_ID, Collections.singletonList(PLUGIN_ID));
        Mockito.when((Object)this.userSettingService.get((String)ArgumentMatchers.eq((Object)USER_1))).thenReturn((Object)userSetting);
        this.getContainer().unregisterComponent(PluginSettingService.class);
        this.getContainer().unregisterComponent(ChannelManager.class);
        this.getContainer().unregisterComponent(UserSettingService.class);
        this.getContainer().unregisterComponent(JPAUserSettingServiceImpl.class);
        this.getContainer().unregisterComponent(UserACL.class);
        this.getContainer().registerComponentInstance((Object)PluginSettingService.class.getName(), (Object)this.pluginSettingService);
        this.getContainer().registerComponentInstance((Object)ChannelManager.class.getName(), (Object)this.channelManager);
        this.getContainer().registerComponentInstance((Object)UserSettingService.class.getName(), (Object)this.userSettingService);
        this.getContainer().registerComponentInstance((Object)UserACL.class.getName(), (Object)this.userACL);
    }

    public void tearDown() throws Exception {
        this.getContainer().unregisterComponent((Object)PluginSettingService.class.getName());
        this.getContainer().unregisterComponent((Object)ChannelManager.class.getName());
        this.getContainer().unregisterComponent((Object)UserSettingService.class.getName());
        this.getContainer().unregisterComponent((Object)UserACL.class.getName());
        super.tearDown();
    }

    public void testUnauthorizedNotSameUserGetSettings() throws Exception {
        String path = this.getPath(USER_1, "");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startSessionAs(USER_2);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        NotificationSettingsRestServiceTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)401, (int)resp.getStatus());
    }

    public void testAdminGetSettings() throws Exception {
        String path = this.getPath(USER_1, "");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startSessionAs(USER_2);
        Mockito.when((Object)this.userACL.isUserInGroup((String)ArgumentMatchers.eq((Object)"admins"))).thenReturn((Object)true);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        NotificationSettingsRestServiceTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)200, (int)resp.getStatus());
        UserNotificationSettings notificationSettings = (UserNotificationSettings)resp.getEntity();
        NotificationSettingsRestServiceTest.assertNotNull((Object)notificationSettings);
    }

    public void testGetSettingsSameUser() throws Exception {
        String path = this.getPath(USER_1, "");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startSessionAs(USER_1);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        NotificationSettingsRestServiceTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)200, (int)resp.getStatus());
        UserNotificationSettings notificationSettings = (UserNotificationSettings)resp.getEntity();
        NotificationSettingsRestServiceTest.assertNotNull((Object)notificationSettings);
        NotificationSettingsRestServiceTest.assertNotNull((Object)notificationSettings.getChannels());
        NotificationSettingsRestServiceTest.assertEquals((int)1, (int)notificationSettings.getChannels().size());
        NotificationSettingsRestServiceTest.assertNotNull((Object)notificationSettings.getGroups());
        NotificationSettingsRestServiceTest.assertEquals((int)1, (int)notificationSettings.getGroups().size());
        NotificationSettingsRestServiceTest.assertNotNull(notificationSettings.getGroups().get(0));
        NotificationSettingsRestServiceTest.assertEquals((String)GROUP_PROVIDER_ID, (String)((GroupProvider)notificationSettings.getGroups().get(0)).getGroupId());
        NotificationSettingsRestServiceTest.assertNotNull((Object)((GroupProvider)notificationSettings.getGroups().get(0)).getGroupId());
        NotificationSettingsRestServiceTest.assertNotNull((Object)notificationSettings.getChannelStatus());
        NotificationSettingsRestServiceTest.assertEquals((int)1, (int)notificationSettings.getChannelStatus().size());
        NotificationSettingsRestServiceTest.assertTrue((boolean)((Boolean)notificationSettings.getChannelStatus().get(CHANNEL_ID)));
    }

    public void testGetSettingsSameUserEmptyPlugins() throws Exception {
        Mockito.when((Object)this.pluginSettingService.getGroupPlugins()).thenReturn(EMPTY_GROUP_PROVIDER);
        this.testGetSettingsSameUser();
    }

    public void testSaveDisableChannel() throws Exception {
        String path = this.getPath(USER_1, "channel/channelId");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "PATCH", null);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startSessionAs(USER_1);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getFormHeaders(), "enable=false".getBytes(), envctx);
        NotificationSettingsRestServiceTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)204, (int)resp.getStatus());
        ((UserSettingService)Mockito.verify((Object)this.userSettingService, (VerificationMode)Mockito.times((int)1))).save((UserSetting)ArgumentMatchers.any());
    }

    public void testSaveSettings() throws Exception {
        String path = this.getPath(USER_1, "plugin/pluginId");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "PATCH", null);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startSessionAs(USER_1);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getFormHeaders(), "channels=channelId=true&digest=Weekly".getBytes(), envctx);
        NotificationSettingsRestServiceTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)204, (int)resp.getStatus());
        ((UserSettingService)Mockito.verify((Object)this.userSettingService, (VerificationMode)Mockito.times((int)1))).save((UserSetting)ArgumentMatchers.argThat(userSetting -> userSetting.isActive(CHANNEL_ID, PLUGIN_ID) && userSetting.isChannelGloballyActive(CHANNEL_ID) && userSetting.isInWeekly(PLUGIN_ID)));
    }

    private MultivaluedMap<String, String> getFormHeaders() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        return headers;
    }

    private String getPath(String username, String prefix) {
        return "/notifications/settings/" + username + "/" + prefix;
    }

    private void startSessionAs(String username) {
        Identity identity = new Identity(username);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    private static AbstractChannel newChannel() {
        return new AbstractChannel(){

            public void registerTemplateProvider(TemplateProvider provider) {
                throw new UnsupportedOperationException();
            }

            protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
                throw new UnsupportedOperationException();
            }

            public ChannelKey getKey() {
                return ChannelKey.key((String)NotificationSettingsRestServiceTest.CHANNEL_ID);
            }

            public String getId() {
                return NotificationSettingsRestServiceTest.CHANNEL_ID;
            }

            public void dispatch(NotificationContext ctx, String userId) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        PLUGIN_PROVIDER.setType(PLUGIN_ID);
        PLUGIN_CONFIG.setPluginId(PLUGIN_ID);
        PLUGIN_CONFIG.setGroupId(GROUP_PROVIDER_ID);
        PLUGINS = Collections.singletonList(PLUGIN_PROVIDER);
        GROUP_PROVIDER = new GroupProvider(GROUP_PROVIDER_ID);
        GROUP_PROVIDER.setPluginInfos(PLUGINS);
        GROUPS = Collections.singletonList(GROUP_PROVIDER);
        EMPTY_GROUP_PROVIDER = Collections.singletonList(new GroupProvider(GROUP_PROVIDER_ID));
        CHANNELS = Collections.singletonList(NotificationSettingsRestServiceTest.newChannel());
    }
}

