/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;

public class MockNotificationService
implements NotificationService {
    private Map<String, List<NotificationInfo>> storedDigest = new HashMap<String, List<NotificationInfo>>();
    private Map<String, List<NotificationInfo>> storeInstantly = new HashMap<String, List<NotificationInfo>>();
    private Map<String, List<NotificationInfo>> storeWebNotifs = new HashMap<String, List<NotificationInfo>>();

    public int sizeOfInstantly() {
        return this.storeInstantly.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfWebNotifs() {
        return this.storeWebNotifs.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfStoredDigest() {
        return this.storedDigest.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfStoredDigest(String username) {
        return this.storedDigest.containsKey(username) ? this.storedDigest.get(username).size() : 0;
    }

    public void clearAll() {
        this.clearOfStoredDigest();
        this.clearOfInstantly();
        this.clearOfWebNotifs();
    }

    public void clearOfStoredDigest() {
        this.storedDigest.clear();
    }

    public void clearOfInstantly() {
        this.storeInstantly.clear();
    }

    public void clearOfWebNotifs() {
        this.storeWebNotifs.clear();
    }

    public List<NotificationInfo> storeDigest(String username) {
        return this.storedDigest.containsKey(username) ? this.storedDigest.get(username) : Collections.emptyList();
    }

    public List<NotificationInfo> storeInstantly(String username) {
        return this.storeInstantly.containsKey(username) ? this.storeInstantly.get(username) : Collections.emptyList();
    }

    public List<NotificationInfo> storeWebNotifs(String username) {
        return this.storeWebNotifs.containsKey(username) ? this.storeWebNotifs.get(username) : Collections.emptyList();
    }

    public void process(NotificationInfo notification) throws Exception {
        String pluginId = notification.getKey().getId();
        PluginSettingService pluginSettingService = (PluginSettingService)CommonsUtils.getService(PluginSettingService.class);
        if (!pluginSettingService.isActive("MAIL_CHANNEL", pluginId)) {
            return;
        }
        List userIds = notification.getSendToUserIds();
        UserSettingService userSettingService = (UserSettingService)CommonsUtils.getService(UserSettingService.class);
        if (notification.isSendAll()) {
            SettingService settingService = (SettingService)CommonsUtils.getService(SettingService.class);
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            long usersCount = settingService.countContextsByType(Context.USER.getName());
            int maxResults = 100;
            int i = 0;
            while ((long)i < usersCount) {
                userIds = settingService.getContextNamesByType(Context.USER.getName(), i, maxResults);
                if (notification.isSendAllInternals()) {
                    userIds = userIds.stream().filter(userId -> {
                        try {
                            UserProfile userProfile = organizationService.getUserProfileHandler().findUserProfileByName(userId);
                            return userProfile == null || !StringUtils.equals((CharSequence)userProfile.getAttribute(UserProfile.OTHER_KEYS[2]), (CharSequence)"true");
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).collect(Collectors.toList());
                }
                if (!notification.getExcludedUsersIds().isEmpty()) {
                    userIds = userIds.stream().filter(userId -> !notification.isExcluded(userId)).collect(Collectors.toList());
                }
                i += maxResults;
            }
        }
        userIds = userIds.stream().filter(userId -> userSettingService.get(userId).isEnabled()).collect(Collectors.toList());
        for (String userId2 : userIds) {
            UserSetting userSetting = userSettingService.get(userId2);
            if (userSetting == null) {
                userSetting = userSettingService.getDefaultSettings();
                userSetting.setUserId(userId2);
            }
            if (userSetting.isActive("MAIL_CHANNEL", pluginId)) {
                if (!this.storeInstantly.containsKey(userId2)) {
                    this.storeInstantly.put(userId2, new ArrayList());
                }
                this.storeInstantly.get(userId2).add(notification);
            }
            if (userSetting.isActive("WEB_CHANNEL", pluginId)) {
                if (!this.storeWebNotifs.containsKey(userId2)) {
                    this.storeWebNotifs.put(userId2, new ArrayList());
                }
                this.storeWebNotifs.get(userId2).add(notification);
            }
            if (!userSetting.isInDaily(pluginId) && !userSetting.isInWeekly(pluginId)) continue;
            if (!this.storedDigest.containsKey(userId2)) {
                this.storedDigest.put(userId2, new ArrayList());
            }
            this.storedDigest.get(userId2).add(notification);
        }
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            this.process(message);
        }
    }

    public void digest(NotificationContext context) throws Exception {
    }
}

