/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class SharedActivitySpaceStreamPlugin
extends BaseNotificationPlugin {
    public static final String ID = "SharedActivitySpaceStreamPlugin";
    protected ActivityStorage activityStorage;

    public SharedActivitySpaceStreamPlugin(InitParams initParams, ActivityStorage activityStorage) {
        super(initParams);
        this.activityStorage = activityStorage;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        try {
            ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
            String originalTitle = (String)ctx.value(SocialNotificationUtils.ORIGINAL_TITLE);
            String titleShared = (String)ctx.value(SocialNotificationUtils.ORIGINAL_TITLE_SHARED);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner());
            String poster = Utils.getUserId(activity.getPosterId());
            return NotificationInfo.instance().key(this.getId()).setSpaceId(Long.parseLong(space.getId())).with(SocialNotificationUtils.POSTER.getKey(), poster).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.SPACE_ID.getKey(), space.getId()).with(SocialNotificationUtils.ORIGINAL_TITLE.getKey(), originalTitle).with(SocialNotificationUtils.ORIGINAL_TITLE_SHARED.getKey(), titleShared).setFrom(poster).to(Utils.getDestinataires(activity, space)).end();
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }
}

