/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.webui;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.oauth.webui.UIRegisterOAuth;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;

public class OAuthLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<PortalRequestContext> {
    private final Logger log = LoggerFactory.getLogger(OAuthLifecycle.class);
    private AuthenticationRegistry authRegistry;

    public void onInit(Application app) throws Exception {
        this.authRegistry = (AuthenticationRegistry)app.getApplicationServiceContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
    }

    public void onStartRequest(Application app, PortalRequestContext context) throws Exception {
        ApplicationMessage appMessage;
        OAuthException gtnOAuthException;
        String socialNetworkName;
        User oauthAuthenticatedUser;
        HttpServletRequest httpRequest = context.getRequest();
        HttpSession httpSession = httpRequest.getSession();
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        Boolean isOnFlyError = (Boolean)httpRequest.getSession().getAttribute("oauth_onfly_error");
        if (isOnFlyError != null) {
            httpRequest.getSession().removeAttribute("oauth_onfly_error");
        }
        if ((oauthAuthenticatedUser = (User)this.authRegistry.getAttributeOfClient(httpRequest, "_authenticatedPortalUser")) != null) {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found user, which has been authenticated through OAuth. Username is " + oauthAuthenticatedUser.getUserName()));
            }
            if (!uiMaskWS.isShow() || !uiMaskWS.getUIComponent().getClass().equals(UIRegisterOAuth.class)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Showing registration form for OAuth registration");
                }
                UIComponent uiRegisterOauth = uiMaskWS.createUIComponent(UIRegisterOAuth.class, null, null);
                uiMaskWS.setCssClasses("TransparentMask");
                uiMaskWS.setWindowSize(-1, -1);
                uiMaskWS.setUIComponent(uiRegisterOauth);
                if (isOnFlyError != null && isOnFlyError.booleanValue()) {
                    ApplicationMessage msg = new ApplicationMessage("UIRegisterForm.message.signUpOnFlyError", new Object[0], 1);
                    msg.setArgsLocalized(false);
                    uiApp.addMessage(msg);
                }
            }
        }
        if ((socialNetworkName = (String)httpSession.getAttribute("_linkedOAuthProviderUsernameAttrName")) != null) {
            httpSession.removeAttribute("_linkedOAuthProviderUsernameAttrName");
            ApplicationMessage msg = new ApplicationMessage("UIAccountSocial.msg.successful-link", new Object[]{socialNetworkName, context.getRemoteUser()});
            msg.setArgsLocalized(false);
            uiApp.addMessage(msg);
        }
        if ((gtnOAuthException = (OAuthException)((Object)httpSession.getAttribute("_oauthExceptionAfterFailedLink"))) != null) {
            httpSession.removeAttribute("_oauthExceptionAfterFailedLink");
            Object[] args = new Object[]{gtnOAuthException.getExceptionAttribute("OAuthProviderUsername"), gtnOAuthException.getExceptionAttribute("OAuthProviderName")};
            appMessage = new ApplicationMessage("UIAccountSocial.msg.failed-link", args, 1);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
        }
        if ((gtnOAuthException = (OAuthException)((Object)httpSession.getAttribute("_oauthException"))) != null) {
            String key;
            httpSession.removeAttribute("_oauthException");
            if (gtnOAuthException.getExceptionCode() == OAuthExceptionCode.USER_DENIED_SCOPE) {
                key = "UIAccountSocial.msg.access-denied";
            } else {
                key = "UIAccountSocial.msg.oauth-error";
                this.log.error((Object)"Unspecified error during OAuth flow", (Throwable)gtnOAuthException);
            }
            appMessage = new ApplicationMessage(key, null, 1);
            uiApp.addMessage(appMessage);
        }
    }

    public void onFailRequest(Application app, PortalRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, PortalRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

