/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.webui;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.oauth.webui.UIOAuthInvitationForm;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.register.UIRegisterForm;
import org.exoplatform.portal.webui.register.UIRegisterInputSet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.OAuthPrincipal;

@ComponentConfig(template="system:/groovy/portal/webui/portal/UIRegisterOAuthForm.gtmpl")
public class UIRegisterOAuth
extends UIContainer {
    private static Logger log = LoggerFactory.getLogger(org.exoplatform.portal.webui.register.UIRegisterOAuth.class);
    private static final String[] ACTIONS = new String[]{"SubscribeOAuth", "Reset", "Cancel"};
    static final String REGISTER_FORM_CONFIG_ID = "UIRegisterFormOAuth";
    private final AuthenticationRegistry authRegistry;
    private User portalUser = null;

    public UIRegisterOAuth() throws Exception {
        this.addChild(UIRegisterForm.class, REGISTER_FORM_CONFIG_ID, REGISTER_FORM_CONFIG_ID);
        this.addChild(UIOAuthInvitationForm.class, null, null);
        UIRegisterForm uiRegisterForm = (UIRegisterForm)this.getChild(UIRegisterForm.class);
        uiRegisterForm.setActions(ACTIONS);
        this.authRegistry = (AuthenticationRegistry)this.getApplicationComponent(AuthenticationRegistry.class);
    }

    private void setupUserToRegisterForm() {
        UIRegisterForm uiRegisterForm = (UIRegisterForm)this.getChild(UIRegisterForm.class);
        UIRegisterInputSet uiRegisterInputSet = (UIRegisterInputSet)uiRegisterForm.getChild(UIRegisterInputSet.class);
        uiRegisterInputSet.getUIStringInput("username").setValue((Object)this.portalUser.getUserName());
        uiRegisterInputSet.getUIStringInput("firstName").setValue((Object)this.portalUser.getFirstName());
        uiRegisterInputSet.getUIStringInput("lastName").setValue((Object)this.portalUser.getLastName());
        uiRegisterInputSet.getUIStringInput("emailAddress").setValue((Object)this.portalUser.getEmail());
        uiRegisterInputSet.getUIStringInput("password").setValue(null);
        uiRegisterInputSet.getUIStringInput("confirmPassword").setValue(null);
        uiRegisterInputSet.getUIStringInput("displayName").setValue((Object)this.portalUser.getDisplayName());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        HttpServletRequest request = Util.getPortalRequestContext().getRequest();
        User pUser = (User)this.authRegistry.getAttributeOfClient(request, "_authenticatedPortalUser");
        if (this.portalUser == null || pUser != null && pUser != this.portalUser) {
            if (pUser == null) {
                log.warn((Object)"portalUser from OAuth login is not available!");
                pUser = new UserImpl();
                pUser.setDisplayName("");
            }
            this.portalUser = pUser;
            this.setupUserToRegisterForm();
            User detectedUser = (User)this.authRegistry.getAttributeOfClient(request, "_authenticatedPortalUserDetected");
            if (detectedUser != null) {
                ((UIRegisterForm)this.getChild(UIRegisterForm.class)).setRendered(false);
                UIOAuthInvitationForm invitationForm = (UIOAuthInvitationForm)this.getChild(UIOAuthInvitationForm.class);
                invitationForm.setRendered(true);
                String detected = detectedUser.getUserName();
                if (!detected.equals(pUser.getUserName()) && detectedUser.getEmail().equals(pUser.getEmail())) {
                    detected = detectedUser.getEmail();
                }
                invitationForm.setDetectedUserName(detected);
            } else {
                ((UIRegisterForm)this.getChild(UIRegisterForm.class)).setRendered(true);
                ((UIOAuthInvitationForm)this.getChild(UIOAuthInvitationForm.class)).setRendered(false);
            }
        }
        super.processRender(context);
    }

    public static class SubscribeOAuthActionListener
    extends UIRegisterForm.SubscribeActionListener {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            HttpServletRequest httpRequest;
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            UIRegisterForm uiRegisterForm = (UIRegisterForm)event.getSource();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)uiRegisterForm.getApplicationComponent(AuthenticationRegistry.class);
            OAuthPrincipal oauthPrincipal = (OAuthPrincipal)authRegistry.getAttributeOfClient(httpRequest = portalRequestContext.getRequest(), "_authenticatedOAuthPrincipal");
            if (oauthPrincipal == null) {
                uiApp.addMessage(new ApplicationMessage("UIAccountSocial.msg.not-in-oauth-process", new Object[0], 2));
                return;
            }
            super.execute(event);
            User newUser = (User)context.getAttribute("UIRegisterForm$User");
            if (newUser != null) {
                OrganizationService orgService = (OrganizationService)uiRegisterForm.getApplicationComponent(OrganizationService.class);
                UserProfileHandler profileHandler = orgService.getUserProfileHandler();
                UserProfile newUserProfile = profileHandler.findUserProfileByName(newUser.getUserName());
                if (newUserProfile == null) {
                    newUserProfile = orgService.getUserProfileHandler().createUserProfileInstance(newUser.getUserName());
                }
                newUserProfile.setAttribute(oauthPrincipal.getOauthProviderType().getUserNameAttrName(), oauthPrincipal.getUserName());
                try {
                    profileHandler.saveUserProfile(newUserProfile, true);
                }
                catch (OAuthException gtnOAuthException) {
                    if (gtnOAuthException.getExceptionCode() == OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME) {
                        orgService.getUserHandler().removeUser(newUser.getUserName(), true);
                        Object[] args = new Object[]{gtnOAuthException.getExceptionAttribute("OAuthProviderUsername"), gtnOAuthException.getExceptionAttribute("OAuthProviderName")};
                        ApplicationMessage appMessage = new ApplicationMessage("UIAccountSocial.msg.failed-registration", args, 1);
                        uiApp.addMessage(appMessage);
                        return;
                    }
                    throw gtnOAuthException;
                }
                authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
                authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUserDetected");
                uiApp.clearMessages();
                UIMaskWorkspace.CloseActionListener closePopupListener = new UIMaskWorkspace.CloseActionListener();
                closePopupListener.execute(event);
                SiteKey siteKey = portalRequestContext.getSiteKey();
                NodeURL urlToRedirect = (NodeURL)portalRequestContext.createURL(NodeURL.TYPE);
                urlToRedirect.setResource(new NavigationResource(siteKey, portalRequestContext.getNodePath()));
                portalRequestContext.getJavascriptManager().addJavascript((CharSequence)("window.location = '" + urlToRedirect.toString() + "';"));
            }
        }
    }

    public static class CancelActionListener
    extends UIMaskWorkspace.CloseActionListener {
        public void execute(Event<UIComponent> event) throws Exception {
            UIComponent ui = (UIComponent)event.getSource();
            super.execute(event);
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)((UIComponent)event.getSource()).getApplicationComponent(AuthenticationRegistry.class);
            HttpServletRequest httpRequest = Util.getPortalRequestContext().getRequest();
            authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal");
            authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
            authRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUserDetected");
            UIRegisterOAuth uiOauth = (UIRegisterOAuth)ui.getAncestorOfType(UIRegisterOAuth.class);
            if (uiOauth != null) {
                uiOauth.portalUser = null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Registration with OAuth properties terminated. Clearing authentication context");
            }
        }
    }

    public static class ResetActionListener
    extends EventListener<UIRegisterForm> {
        public void execute(Event<UIRegisterForm> event) throws Exception {
            UIRegisterForm registerForm = (UIRegisterForm)event.getSource();
            UIRegisterOAuth uiRegisterOAuth = (UIRegisterOAuth)registerForm.getAncestorOfType(UIRegisterOAuth.class);
            uiRegisterOAuth.setupUserToRegisterForm();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)registerForm);
        }
    }
}

