/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;

public abstract class OAuthAbstractFilter
implements Filter {
    public static final String COOKIE_LAST_LOGIN = "last_login_username";
    protected ThreadLocal<PortalContainer> container = new ThreadLocal();
    private Boolean oauthEnable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getRemoteUser() != null) {
            Cookie cookie = new Cookie(COOKIE_LAST_LOGIN, req.getRemoteUser());
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(3600);
            cookie.setHttpOnly(true);
            res.addCookie(cookie);
            chain.doFilter(request, response);
            return;
        }
        PortalContainer c = PortalContainer.getCurrentInstance((ServletContext)request.getServletContext());
        if (c == null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        try {
            this.container.set(c);
            if (!this.isOauthEnable()) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            AuthenticationRegistry authReg = this.getService(AuthenticationRegistry.class);
            User authenticated = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUserForJaas");
            if (authenticated != null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            User oauthAuthenticatedUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUser");
            if (oauthAuthenticatedUser == null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            this.executeFilter(req, res, chain);
        }
        finally {
            this.container.set(null);
        }
    }

    protected abstract void executeFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean isOauthEnable() {
        if (this.oauthEnable == null) {
            OAuthProviderTypeRegistry registry = this.getService(OAuthProviderTypeRegistry.class);
            this.oauthEnable = registry.isOAuthEnabled();
        }
        return this.oauthEnable;
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.container.get().getComponentInstanceOfType(clazz);
    }

    protected ServletContext getContext() {
        return this.container.get().getPortalContext();
    }
}

