/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.oauth.filter.OAuthAbstractFilter;
import org.exoplatform.oauth.service.OAuthRegistrationServices;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;

public class OauthSignupOnflyFilter
extends OAuthAbstractFilter {
    static final String SESSION_KEY_SIGNUP_ON_FLY_ERROR = "__onfly_error";

    @Override
    protected void executeFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean isOnFly;
        AuthenticationRegistry authReg = this.getService(AuthenticationRegistry.class);
        User detectedUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUserDetected");
        if (detectedUser != null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        OAuthPrincipal principal = (OAuthPrincipal)authReg.getAttributeOfClient(req, "_authenticatedOAuthPrincipal");
        OAuthRegistrationServices regService = this.getService(OAuthRegistrationServices.class);
        boolean bl = isOnFly = regService != null && regService.isRegistrationOnFly((OAuthProviderType<? extends AccessTokenContext>)principal.getOauthProviderType());
        if (isOnFly) {
            String oauth = principal.getOauthProviderType().getKey() + "_" + principal.getUserName();
            String onFlyError = (String)req.getSession().getAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR);
            if (onFlyError != null) {
                if (oauth.equals(onFlyError)) {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    return;
                }
                req.getSession().removeAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR);
            }
            if ((detectedUser = regService.detectGateInUser(req, (OAuthPrincipal<? extends AccessTokenContext>)principal)) != null) {
                authReg.setAttributeOfClient(req, "_authenticatedPortalUserDetected", (Object)detectedUser);
            } else {
                OrganizationService orgService = this.getService(OrganizationService.class);
                if (orgService instanceof ComponentRequestLifecycle) {
                    RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
                }
                User newUser = regService.createGateInUser((OAuthPrincipal<? extends AccessTokenContext>)principal);
                if (orgService instanceof ComponentRequestLifecycle) {
                    RequestLifeCycle.end();
                }
                if (newUser != null) {
                    authReg.removeAttributeOfClient(req, "_authenticatedPortalUser");
                    res.sendRedirect(this.getContext().getContextPath());
                    return;
                }
                req.getSession().setAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR, (Object)oauth);
                req.getSession().setAttribute("oauth_onfly_error", (Object)Boolean.TRUE);
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }
}

