/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.test;

import io.meeds.oauth.facebook.FacebookAccessTokenContext;
import io.meeds.oauth.facebook.FacebookPrincipalProcessor;
import io.meeds.oauth.linkedin.LinkedInPrincipalProcessor;
import io.meeds.oauth.linkedin.LinkedinAccessTokenContext;
import io.meeds.oauth.linkedin.LinkedinProcessorImpl;
import io.meeds.oauth.principal.DefaultPrincipalProcessor;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthPrincipalProcessor;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.organization.User;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.web.oauth-configuration-local.xml")})
public class TestOAuthPrincipalProcessor
extends AbstractKernelTest {
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;

    public void setUp() throws Exception {
        super.setUp();
        this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)this.getContainer().getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
        this.begin();
    }

    public void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testOAuthPrincipalRegistration() {
        OAuthProviderType oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("FACEBOOK", FacebookAccessTokenContext.class);
        TestOAuthPrincipalProcessor.assertNotNull((String)"Facebook provider isn't found", (Object)oAuthProvider);
        OAuthPrincipalProcessor oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessor.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessor.assertEquals(FacebookPrincipalProcessor.class, oauthPrincipalProcessor.getClass());
        oAuthProvider = this.oAuthProviderTypeRegistry.getOAuthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
        TestOAuthPrincipalProcessor.assertNotNull((String)"Twitter provider isn't found", (Object)oAuthProvider);
        oauthPrincipalProcessor = oAuthProvider.getOauthPrincipalProcessor();
        TestOAuthPrincipalProcessor.assertNotNull((Object)oauthPrincipalProcessor);
        TestOAuthPrincipalProcessor.assertEquals(LinkedInPrincipalProcessor.class, oauthPrincipalProcessor.getClass());
    }

    public void testDefaultGenerateGateInUser() {
        OAuthProviderType providerType = new OAuthProviderType("OAUTH", true, "", null, null, "", "");
        OAuthPrincipal principal = new OAuthPrincipal("username", "firstName", "lastName", "displayName", "email@localhost.com", null, providerType);
        DefaultPrincipalProcessor principalProcessor = new DefaultPrincipalProcessor();
        User user = principalProcessor.convertToGateInUser(principal);
        TestOAuthPrincipalProcessor.assertNotNull((Object)user);
        TestOAuthPrincipalProcessor.assertEquals((String)"username", (String)user.getUserName());
        TestOAuthPrincipalProcessor.assertEquals((String)"email@localhost.com", (String)user.getEmail());
        TestOAuthPrincipalProcessor.assertEquals((String)"firstName", (String)user.getFirstName());
        TestOAuthPrincipalProcessor.assertEquals((String)"lastName", (String)user.getLastName());
        TestOAuthPrincipalProcessor.assertEquals((String)"displayName", (String)user.getDisplayName());
    }

    public void testLinkedInGenerateGateInUser() {
        OAuthProviderType providerType = new OAuthProviderType("LINKEDIN", true, "", null, null, "", "");
        OAuthPrincipal principal = new OAuthPrincipal("randomString", "firstName", "lastName", "displayName", "linkedin_user@localhost.com", null, providerType);
        LinkedInPrincipalProcessor principalProcessor = new LinkedInPrincipalProcessor();
        User user = principalProcessor.convertToGateInUser(principal);
        TestOAuthPrincipalProcessor.assertNotNull((Object)user);
        TestOAuthPrincipalProcessor.assertEquals((String)"linkedin_user", (String)user.getUserName());
        TestOAuthPrincipalProcessor.assertEquals((String)"linkedin_user@localhost.com", (String)user.getEmail());
        TestOAuthPrincipalProcessor.assertEquals((String)"firstName", (String)user.getFirstName());
        TestOAuthPrincipalProcessor.assertEquals((String)"lastName", (String)user.getLastName());
        TestOAuthPrincipalProcessor.assertEquals((String)"displayName", (String)user.getDisplayName());
    }

    public void testprocessOAuthInteraction() throws IOException, ExecutionException, InterruptedException {
        String apiKey = "86joj41np68x05";
        String apiSecret = "B6Sz1fAUPGxRSraC";
        String scope = "r_liteprofile r_emailaddress w_member_social";
        String secretState = "secret999999";
        String redirectURL = "http://127.0.0.1:8080/portal/linkedinAuth";
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/portal");
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/linkedinAuth");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        LinkedinProcessorImpl linkedinProcessor = new LinkedinProcessorImpl(apiKey, apiSecret, redirectURL, scope, 0);
        linkedinProcessor.processOAuthInteraction(request, response);
        String reponseType = linkedinProcessor.oAuth20Service.getResponseType();
        TestOAuthPrincipalProcessor.assertEquals((String)"code", (String)reponseType);
        String state = linkedinProcessor.processOAuthInteraction(request, response).getState().name();
        TestOAuthPrincipalProcessor.assertEquals((String)"AUTH", (String)state);
        String redirect = linkedinProcessor.oAuth20Service.getAuthorizationUrl(secretState);
        TestOAuthPrincipalProcessor.assertEquals((String)"https://www.linkedin.com/oauth/v2/authorization?response_type=code&client_id=86joj41np68x05&redirect_uri=http%3A%2F%2F127.0.0.1%3A8080%2Fportal%2FlinkedinAuth&scope=r_liteprofile%20r_emailaddress%20w_member_social&state=secret999999", (String)redirect);
    }
}

