/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.google;

import com.google.api.services.oauth2.model.Userinfo;
import io.meeds.oauth.google.GoogleAccessTokenContext;
import io.meeds.oauth.google.GoogleProcessor;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.utils.OAuthUtils;
import io.meeds.oauth.web.OAuthProviderFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class GoogleFilter
extends OAuthProviderFilter<GoogleAccessTokenContext> {
    @Override
    protected OAuthProviderType<GoogleAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("GOOGLE", GoogleAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<GoogleAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<GoogleAccessTokenContext> interactionState) {
        GoogleAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        Userinfo userInfo = ((GoogleProcessor)this.getOauthProviderProcessor()).obtainUserInfo(accessTokenContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Obtained tokenResponse from Google authentication: " + accessTokenContext));
            this.log.trace((Object)("User info from Google: " + userInfo));
        }
        OAuthPrincipal<GoogleAccessTokenContext> oauthPrincipal = OAuthUtils.convertGoogleInfoToOAuthPrincipal(userInfo, accessTokenContext, this.getOAuthProvider());
        return oauthPrincipal;
    }
}

