/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import io.meeds.oauth.spi.AccessTokenContext;
import java.io.Serializable;

public class GoogleAccessTokenContext
extends AccessTokenContext
implements Serializable {
    private static final long serialVersionUID = -7038197192745766989L;
    private final GoogleTokenResponse tokenData;

    public GoogleAccessTokenContext(GoogleTokenResponse tokenData, String ... scopes) {
        super(scopes);
        if (tokenData == null) {
            throw new IllegalArgumentException("tokenData can't be null");
        }
        this.tokenData = tokenData;
    }

    public GoogleAccessTokenContext(GoogleTokenResponse tokenData, String scopeAsString) {
        super(scopeAsString);
        if (tokenData == null) {
            throw new IllegalArgumentException("tokenData can't be null");
        }
        this.tokenData = tokenData;
    }

    public GoogleTokenResponse getTokenData() {
        return this.tokenData;
    }

    @Override
    public String getAccessToken() {
        return this.tokenData.getAccessToken();
    }

    @Override
    public String toString() {
        return "GoogleAccessTokenContext [" + ("accessToken=" + this.tokenData) + super.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        GoogleAccessTokenContext thatt = (GoogleAccessTokenContext)that;
        return this.tokenData.equals((Object)thatt.getTokenData());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 13 + this.tokenData.hashCode();
    }
}

