/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class ExoBlobCrypterSecurityToken
extends BlobCrypterSecurityToken {
    protected static final String PORTAL_CONTAINER_KEY = "p";
    protected static final String HOST_NAME = "h";
    protected static final String PORTAL_OWNER_KEY = "w";
    protected String portalContainer;
    private String hostName;
    private String portalOwner;

    public ExoBlobCrypterSecurityToken(String container, String domain, String activeUrl, Map<String, String> values) {
        super(container, domain, activeUrl, values);
    }

    public String getPortalContainer() {
        return this.portalContainer;
    }

    public void setPortalContainer(String portalContainer) {
        this.portalContainer = portalContainer;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPortalOwner() {
        return this.portalOwner;
    }

    public void setPortalOwner(String portalOwner) {
        this.portalOwner = portalOwner;
    }

    public Map<String, String> toMap() {
        Map map = super.toMap();
        if (this.portalContainer != null) {
            map.put(PORTAL_CONTAINER_KEY, this.portalContainer);
        }
        if (this.hostName != null) {
            map.put(HOST_NAME, this.hostName);
        }
        if (this.portalOwner != null) {
            map.put(PORTAL_OWNER_KEY, this.portalOwner);
        }
        return map;
    }

    static BlobCrypterSecurityToken decrypt(BlobCrypter crypter, String container, String domain, String token, String activeUrl) throws BlobCrypterException {
        Map values = crypter.unwrap(token);
        ExoBlobCrypterSecurityToken t = new ExoBlobCrypterSecurityToken(container, domain, activeUrl, values);
        t.setOwnerId((String)values.get(AbstractSecurityToken.Keys.OWNER.getKey()));
        t.setViewerId((String)values.get(AbstractSecurityToken.Keys.VIEWER.getKey()));
        t.setAppUrl((String)values.get(AbstractSecurityToken.Keys.APP_URL.getKey()));
        String moduleId = (String)values.get(AbstractSecurityToken.Keys.MODULE_ID.getKey());
        if (moduleId != null) {
            t.setModuleId(Long.parseLong(moduleId));
        }
        t.setTrustedJson((String)values.get(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey()));
        t.setPortalContainer((String)values.get(PORTAL_CONTAINER_KEY));
        t.setActiveUrl(activeUrl);
        t.setHostName((String)values.get(HOST_NAME));
        t.setPortalOwner((String)values.get(PORTAL_OWNER_KEY));
        return t;
    }
}

