/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;

public class ExoService {
    protected Set<Identity> getIdSet(UserId user, GroupId group, SecurityToken token) throws Exception {
        if (token instanceof AnonymousSecurityToken) {
            throw new Exception(Integer.toString(403));
        }
        String userId = user.getUserId(token);
        Identity id = this.getIdentity(userId, token);
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        if (group == null) {
            returnVal.add(id);
        } else {
            switch (group.getType()) {
                case all: 
                case friends: 
                case objectId: {
                    returnVal.addAll(this.getFriendsList(id, token));
                    break;
                }
                case self: {
                    returnVal.add(id);
                }
            }
        }
        return returnVal;
    }

    protected List<Identity> getFriendsList(Identity id, SecurityToken token) throws Exception {
        PortalContainer pc = this.getPortalContainer(token);
        RelationshipManager rm = (RelationshipManager)pc.getComponentInstanceOfType(RelationshipManager.class);
        List rels = rm.getConfirmed(id);
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (Relationship rel : rels) {
            ids.add(rel.getPartner(id));
        }
        return ids;
    }

    protected Set<Identity> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) throws Exception {
        if (token instanceof AnonymousSecurityToken) {
            throw new Exception(Integer.toString(403));
        }
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    protected Identity getIdentity(String id, boolean loadProfile, SecurityToken st) throws Exception {
        PortalContainer pc;
        IdentityManager im;
        Identity identity;
        if (id.contains(":")) {
            id = id.split(":")[1];
        }
        if ((identity = (im = (IdentityManager)(pc = this.getPortalContainer(st)).getComponentInstanceOfType(IdentityManager.class)).getOrCreateIdentity("organization", id, loadProfile)) == null) {
            identity = im.getIdentity(id, loadProfile);
        }
        if (identity == null) {
            throw new Exception("can't find identity: " + id);
        }
        return identity;
    }

    protected Identity getIdentity(String id, SecurityToken st) throws Exception {
        return this.getIdentity(id, false, st);
    }

    protected PortalContainer getPortalContainer(SecurityToken st) {
        String portalName = PortalContainer.getCurrentPortalContainerName();
        if (st instanceof ExoBlobCrypterSecurityToken) {
            String container;
            ExoBlobCrypterSecurityToken crypterSecurityToken = (ExoBlobCrypterSecurityToken)st;
            portalName = container = crypterSecurityToken.getPortalContainer();
        }
        PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
        ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
        return portalContainer;
    }

    protected String getHost(SecurityToken st) {
        String host = null;
        if (st instanceof ExoBlobCrypterSecurityToken) {
            host = ((ExoBlobCrypterSecurityToken)st).getHostName();
        }
        return host;
    }

    protected String getPortalOwner(SecurityToken st) {
        String owner = null;
        if (st instanceof ExoBlobCrypterSecurityToken) {
            owner = ((ExoBlobCrypterSecurityToken)st).getPortalOwner();
        }
        return owner;
    }
}

