/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;
import org.exoplatform.social.service.rest.api.models.ProfileRestOut;

public final class Util {
    private static final Pattern URL_PATTERN = Pattern.compile("^(?i)(((?:(?:ht)tp(?:s?)\\:\\/\\/)?(?:\\w+:\\w+@)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|(?:(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+\\.)+(?:[a-z]{2,}))))|(?:(?:(?:ht)tp(?:s?)\\:\\/\\/)(?:\\w+:\\w+@)?(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+)))(?::[\\d]{1,5})?(?:[\\/|\\?|\\#].*)?$");

    private Util() {
    }

    public static boolean isValidURL(String link) {
        if (link == null || link.length() == 0) {
            return false;
        }
        return URL_PATTERN.matcher(link).matches();
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        Response resp = Response.created((URI)uriInfo.getAbsolutePath()).entity(entity).type(mediaType.toString() + "; charset=utf-8").status(status).build();
        return resp;
    }

    @Deprecated
    public static MediaType getMediaType(String format) throws WebApplicationException {
        if (format.equals("json")) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (format.equals("xml")) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    public static MediaType getMediaType(String expectedFormat, String[] supportedFormats) {
        if (!Util.isSupportedFormat(expectedFormat, supportedFormats)) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        if (expectedFormat.equals("json") && Util.isSupportedFormat("json", supportedFormats)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (expectedFormat.equals("xml") && Util.isSupportedFormat("xml", supportedFormats)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (expectedFormat.equals("atom") && Util.isSupportedFormat("atom", supportedFormats)) {
            return MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    public static String getViewerId() {
        String viewerId = null;
        ConversationState state = ConversationState.getCurrent();
        if (state != null) {
            viewerId = state.getIdentity().getUserId();
        }
        return viewerId;
    }

    @Deprecated
    public static Identity getViewerIdentity(String viewerId) {
        return Util.getUserIdentity(viewerId, false);
    }

    public static Identity getViewerIdentity(String portalContainerName, String viewerId) {
        return Util.getUserIdentity(portalContainerName, viewerId, false);
    }

    @Deprecated
    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Util.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static Identity getUserIdentity(String portalContainerName, String userName, boolean loadProfile) {
        return Util.getIdentityManager(portalContainerName).getOrCreateIdentity("organization", userName, loadProfile);
    }

    @Deprecated
    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final IdentityManager getIdentityManager(String portalContainerName) {
        return (IdentityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(IdentityManager.class);
    }

    @Deprecated
    public static final SpaceService getSpaceService() {
        return (SpaceService)Util.getDefaultPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public static final SpaceService getSpaceService(String portalContainerName) {
        return (SpaceService)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(SpaceService.class);
    }

    @Deprecated
    public static final ActivityManager getActivityManager() {
        return (ActivityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final ActivityManager getActivityManager(String portalContainerName) {
        return (ActivityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(ActivityManager.class);
    }

    @Deprecated
    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final RelationshipManager getRelationshipManager(String portalContainerName) {
        return (RelationshipManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final PortalContainer getPortalContainerByName(String portalContainerName) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)portalContainerName);
    }

    public static final String convertTimestampToTimeString(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date(timestamp));
    }

    @Deprecated
    public static Identity getOwnerIdentityIdFromActivity(ExoSocialActivity activity) {
        IdentityManager identityManager = Util.getIdentityManager();
        ActivityStream activityStream = activity.getActivityStream();
        ActivityStream.Type activityType = activityStream.getType();
        String name = activity.getStreamOwner();
        if (activityType.equals((Object)ActivityStream.Type.USER)) {
            return identityManager.getOrCreateIdentity("organization", name, false);
        }
        return identityManager.getOrCreateIdentity("space", name, false);
    }

    public static Identity getOwnerIdentityIdFromActivity(String portalContainerName, ExoSocialActivity activity) {
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        ActivityStream activityStream = activity.getActivityStream();
        ActivityStream.Type activityType = activityStream.getType();
        String name = activity.getStreamOwner();
        if (activityType.equals((Object)ActivityStream.Type.USER)) {
            return identityManager.getOrCreateIdentity("organization", name, false);
        }
        return identityManager.getOrCreateIdentity("space", name, false);
    }

    public static final String getBaseUrl() {
        HttpServletRequest currentServletRequest = Util.getCurrentServletRequest();
        return currentServletRequest.getScheme() + "://" + currentServletRequest.getServerName() + ":" + currentServletRequest.getServerPort();
    }

    public static HttpServletRequest getCurrentServletRequest() {
        EnvironmentContext environmentContext = EnvironmentContext.getCurrent();
        return (HttpServletRequest)environmentContext.get(HttpServletRequest.class);
    }

    private static boolean isSupportedFormat(String expectedFormat, String[] supportedFormats) {
        for (String supportedFormat : supportedFormats) {
            if (!supportedFormat.equals(expectedFormat)) continue;
            return true;
        }
        return false;
    }

    private static PortalContainer getDefaultPortalContainer() {
        return PortalContainer.getInstance();
    }

    public static void buildAbsoluteAvatarURL(IdentityRestOut resultIdentity) {
        if (resultIdentity.getProfile() != null && resultIdentity.getProviderId() != null) {
            ProfileRestOut resultProfile = resultIdentity.getProfile();
            if (resultProfile.getAvatarUrl() == null || resultProfile.getAvatarUrl().trim().equals("")) {
                if (resultIdentity.getProviderId().equals("space")) {
                    resultProfile.setAvatarUrl(Util.getBaseUrl() + "/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                } else {
                    resultProfile.setAvatarUrl(Util.getBaseUrl() + "/eXoSkin/skin/images/system/UserAvtDefault.png");
                }
            } else if (!resultProfile.getAvatarUrl().startsWith("http://") && !resultProfile.getAvatarUrl().startsWith("https://")) {
                resultProfile.setAvatarUrl(Util.getBaseUrl() + resultProfile.getAvatarUrl());
            }
        }
    }

    public static String buildAbsoluteAvatarURL(Identity resultIdentity) {
        if (resultIdentity.getProfile() != null && resultIdentity.getProviderId() != null) {
            Profile resultProfile = resultIdentity.getProfile();
            if (resultProfile.getAvatarUrl() == null || resultProfile.getAvatarUrl().trim().equals("")) {
                if (resultIdentity.getProviderId().equals("space")) {
                    return Util.getBaseUrl() + "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
                }
                return Util.getBaseUrl() + "/eXoSkin/skin/images/system/UserAvtDefault.png";
            }
            return Util.getBaseUrl() + resultProfile.getAvatarUrl();
        }
        return null;
    }

    public static Identity getAuthenticatedUserIdentity(String portalContainerName) {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            String authenticatedUserRemoteID = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteID, false);
        }
        return null;
    }

    public static boolean isLikedByIdentity(String identityID, ExoSocialActivity activity) {
        String[] likedIdentityIds = activity.getLikeIdentityIds();
        if (activity.getLikeIdentityIds() != null && likedIdentityIds.length > 0) {
            for (int i = 0; i < likedIdentityIds.length; ++i) {
                if (!identityID.equals(likedIdentityIds[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeTypeOfURL(String urlString) {
        String string;
        URLConnection urlConnection = null;
        try {
            String mimeType = null;
            URL url = new URL(urlString);
            urlConnection = url.openConnection();
            mimeType = urlConnection.getContentType();
            if (mimeType != null) {
                String string2 = mimeType;
                return string2;
            }
            mimeType = URLConnection.guessContentTypeFromName(urlString);
            if (mimeType != null) {
                String string3 = mimeType;
                return string3;
            }
            mimeType = URLConnection.guessContentTypeFromStream(urlConnection.getInputStream());
            if (mimeType != null) {
                String string4 = mimeType;
                return string4;
            }
            String string5 = "";
            return string5;
        }
        catch (MalformedURLException e) {
            string = "";
            return string;
        }
        catch (IOException e) {
            string = "";
            return string;
        }
        finally {
            urlConnection = null;
        }
    }

    public static String getDecodeQueryURL(String url) {
        if (Util.isValidURL(url)) {
            try {
                String query = new URL(url).getQuery();
                if (query != null) {
                    String newQuery = URLDecoder.decode(query, "UTF-8");
                    return url.replace(query, newQuery);
                }
            }
            catch (Exception e) {
                return url;
            }
        }
        return url;
    }

    public static boolean hasMentioned(ExoSocialActivity existingActivity, String identityId) {
        for (String mentioner : existingActivity.getMentionedIds()) {
            if (!mentioner.startsWith(identityId)) continue;
            return true;
        }
        return false;
    }

    public static String getRestUrl(String type, String id, String restPath) {
        String version = restPath.split("/")[1];
        String socialResource = restPath.split("/")[2];
        return new StringBuffer(Util.getBaseRestUrl()).append("/").append(version).append("/").append(socialResource).append("/").append(type).append("/").append(id).toString();
    }

    public static String getBaseRestUrl() {
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    public static String getMembersSpaceRestUrl(String id, boolean returnManager, String restPath) {
        StringBuffer spaceMembersRestUrl = new StringBuffer(Util.getRestUrl("spaces", id, restPath)).append("/").append("users");
        if (returnManager) {
            return spaceMembersRestUrl.append("?role=manager").toString();
        }
        return spaceMembersRestUrl.toString();
    }

    public static String getCommentsActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(Util.getRestUrl("activities", activityId, restPath)).append("/").append("comments").toString();
    }

    public static boolean isAnonymous() {
        return IdentityConstants.ANONIM.equals(ConversationState.getCurrent().getIdentity().getUserId());
    }
}

