/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacesadministration;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SocialRest;
import org.exoplatform.social.rest.entity.MembershipEntityWrapper;
import org.exoplatform.social.rest.entity.SpacesAdministrationMembershipsEntity;

@Path(value="v1/social/spacesAdministration")
@Api(tags={"v1/social/spacesAdministration"}, value="v1/social/spacesAdministration", description="Managing Spaces Administration settings")
public class SpacesAdministrationRestResourcesV1
implements SocialRest {
    private SpacesAdministrationService spacesAdministrationService;
    private UserACL userACL;

    public SpacesAdministrationRestResourcesV1(SpacesAdministrationService spacesAdministrationService, UserACL userACL) {
        this.spacesAdministrationService = spacesAdministrationService;
        this.userACL = userACL;
    }

    @GET
    @Path(value="permissions")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Gets all spaces administrators permissions settings", httpMethod="GET", response=Response.class, notes="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User unauthorized"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getAllSettings(@Context UriInfo uriInfo) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<SpacesAdministrationMembershipsEntity> settings = Arrays.asList(new SpacesAdministrationMembershipsEntity("spacesAdministrators", this.spacesAdministrationService.getSpacesAdministratorsMemberships()), new SpacesAdministrationMembershipsEntity("spacesCreators", this.spacesAdministrationService.getSpacesCreatorsMemberships()));
        return EntityBuilder.getResponse(settings, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="permissions/spacesAdministrators")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Gets spaces administrators memberships", httpMethod="GET", response=Response.class, notes="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpacesAdministrators(@Context UriInfo uriInfo) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List memberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        return EntityBuilder.getResponse(new SpacesAdministrationMembershipsEntity("spacesAdministrators", memberships), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="permissions/spacesCreators")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Gets spaces creators memberships", httpMethod="GET", response=Response.class, notes="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpacesCreators(@Context UriInfo uriInfo) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List memberships = this.spacesAdministrationService.getSpacesCreatorsMemberships();
        return EntityBuilder.getResponse(new SpacesAdministrationMembershipsEntity("spacesCreators", memberships), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="permissions/spacesAdministrators")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates spaces creators memberships", httpMethod="PUT", response=Response.class, notes="This updates the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user  but he cannot update his own membership to \"approved\" for a space with a \"validation\" subscription</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateSpacesAdministrators(@Context UriInfo uriInfo, @ApiParam(value="Space membership object to be updated", required=true) List<MembershipEntityWrapper> model) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List memberships = model.stream().map(m -> new MembershipEntry(m.getGroup(), m.getMembershipType())).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(memberships);
        return EntityBuilder.getResponse("", uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="permissions/spacesCreators")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates spaces creators memberships", httpMethod="PUT", response=Response.class, notes="This updates the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user  but he cannot update his own membership to \"approved\" for a space with a \"validation\" subscription</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateSpacesCreators(@Context UriInfo uriInfo, @ApiParam(value="Space membership object to be updated", required=true) List<MembershipEntityWrapper> model) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List memberships = model.stream().map(m -> new MembershipEntry(m.getGroup(), m.getMembershipType())).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(memberships);
        return EntityBuilder.getResponse("", uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

