/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityNameList;
import org.exoplatform.social.service.rest.api.models.PeopleInfo;
import org.exoplatform.webui.utils.TimeConvertUtils;

@Path(value="social/people")
public class PeopleRestService
implements ResourceContainer {
    private static final String SPACE_PREFIX = "space::";
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String IGNORED_STATUS = "ignored";
    private static final String WAITING_STATUS = "waiting";
    private static final String ALIEN_STATUS = "alien";
    private static final String INVITE_ACTION = "Invite";
    private static final String ACCEPT_ACTION = "Accept";
    private static final String DENY_ACTION = "Deny";
    private static final String REVOKE_ACTION = "Revoke";
    private static final String REMOVE_ACTION = "Disconnect";
    private static final String SPACE_MEMBER = "member_of_space";
    private static final String USER_TO_INVITE = "user_to_invite";
    private static final String SHARE_DOCUMENT = "share_document";
    private static final String MENTION_COMMENT = "mention_comment";
    private static final String MENTION_ACTIVITY_STREAM = "mention_activity_stream";
    private static final String NO_ACTION = "NoAction";
    private static final String NO_INFO = "NoInfo";
    private static final long SUGGEST_LIMIT = 20L;
    private static final String DEFAULT_ACTIVITY = "DEFAULT_ACTIVITY";
    private static final String LINK_ACTIVITY = "LINK_ACTIVITY";
    private static final String DOC_ACTIVITY = "DOC_ACTIVITY";
    private static final Log LOG = ExoLogger.getLogger(PeopleRestService.class);
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;

    @RolesAllowed(value={"users"})
    @GET
    @Path(value="suggest.{format}")
    public Response suggestUsernames(@Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String name, @QueryParam(value="currentUser") String currentUser, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="activityId") String activityId, @QueryParam(value="spaceURL") String spaceURL, @PathParam(value="format") String format) throws Exception {
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        ProfileFilter identityFilter = new ProfileFilter();
        identityFilter.setName(name);
        identityFilter.setCompany("");
        identityFilter.setPosition("");
        identityFilter.setSkills("");
        Space currentSpace = this.getSpaceService().getSpaceByUrl(spaceURL);
        ExoSocialActivity currentActivity = this.getActivityManager().getActivity(activityId);
        ArrayList<Identity> excludedIdentityList = identityFilter.getExcludedIdentityList();
        if (excludedIdentityList == null) {
            excludedIdentityList = new ArrayList<Identity>();
        }
        IdentityNameList nameList = new IdentityNameList();
        Identity currentIdentity = Util.getViewerIdentity(currentUser);
        identityFilter.setViewerIdentity(currentIdentity);
        if (PENDING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = this.getRelationshipManager().getOutgoingByFilter(currentIdentity, identityFilter);
            Identity[] result = (Identity[])listAccess.load(0, 20);
            nameList.addToNameList(result);
        } else if (INCOMING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = this.getRelationshipManager().getIncomingByFilter(currentIdentity, identityFilter);
            Identity[] result = (Identity[])listAccess.load(0, 20);
            nameList.addToNameList(result);
        } else if (CONFIRMED_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = this.getRelationshipManager().getConnectionsByFilter(currentIdentity, identityFilter);
            Identity[] result = (Identity[])listAccess.load(0, 20);
            nameList.addToNameList(result);
        } else if (SPACE_MEMBER.equals(typeOfRelation)) {
            List<Object> identities = Arrays.asList(this.getIdentityManager().getIdentitiesByProfileFilter("organization", identityFilter, false).load(0, 20));
            Space space = this.getSpaceService().getSpaceByUrl(spaceURL);
            this.addSpaceOrUserToList(identities, nameList, space, typeOfRelation, 0);
        } else if (USER_TO_INVITE.equals(typeOfRelation)) {
            Space space = this.getSpaceService().getSpaceByUrl(spaceURL);
            if (name != null && name.contains(",")) {
                String[] items;
                for (String item : items = name.split(",")) {
                    IdentityNameList.Option opt = new IdentityNameList.Option();
                    if (item.startsWith(SPACE_PREFIX)) {
                        Space space2 = this.getSpaceService().getSpaceByPrettyName(item.substring(7));
                        opt.setType("space");
                        opt.setValue(SPACE_PREFIX + space2.getPrettyName());
                        opt.setText(space2.getDisplayName());
                        opt.setAvatarUrl(space2.getAvatarUrl());
                        opt.setOrder(3);
                    } else {
                        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", item, false);
                        opt.setType("user");
                        opt.setOrder(1);
                        if (identity != null) {
                            Profile p = identity.getProfile();
                            opt.setValue((String)p.getProperty("username"));
                            opt.setText(p.getFullName() + " (" + (String)p.getProperty("username") + ")");
                            opt.setAvatarUrl(p.getAvatarUrl());
                        } else {
                            opt.setValue(item);
                            opt.setText(item);
                            opt.setInvalid(true);
                        }
                    }
                    nameList.addOption(opt);
                }
                return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
            }
            ListAccess connections = this.getRelationshipManager().getConnectionsByFilter(currentIdentity, identityFilter);
            if (connections != null && connections.getSize() > 0) {
                Identity[] identities;
                int size = connections.getSize();
                for (Identity identity : identities = (Identity[])connections.load(0, (long)size < 20L ? size : 20)) {
                    this.addSpaceOrUserToList(Arrays.asList(identity), nameList, space, typeOfRelation, 1);
                    excludedIdentityList.add(identity);
                }
            }
            ArrayList<Space> exclusions = new ArrayList<Space>();
            long remain = 20L - (long)(nameList.getOptions() != null ? nameList.getOptions().size() : 0);
            if (remain > 0L) {
                identityFilter.setExcludedIdentityList(excludedIdentityList);
                ListAccess listAccess = this.getIdentityManager().getIdentitiesByProfileFilter("organization", identityFilter, false);
                List<Object> identities = Arrays.asList(listAccess.load(0, (int)remain));
                this.addSpaceOrUserToList(identities, nameList, space, typeOfRelation, 2);
            }
            if ((remain = 20L - (long)(nameList.getOptions() != null ? nameList.getOptions().size() : 0)) > 0L) {
                Space[] spaceArray;
                SpaceFilter spaceFilter = new SpaceFilter();
                spaceFilter.setSpaceNameSearchCondition(name);
                ListAccess list = this.getSpaceService().getMemberSpacesByFilter(currentUser, spaceFilter);
                for (Space s : spaceArray = (Space[])list.load(0, (int)remain)) {
                    if (s.equals((Object)space)) {
                        exclusions.add(s);
                        continue;
                    }
                    IdentityNameList.Option opt = new IdentityNameList.Option();
                    opt.setType("space");
                    opt.setValue(SPACE_PREFIX + s.getPrettyName());
                    opt.setText(s.getDisplayName());
                    opt.setAvatarUrl(s.getAvatarUrl());
                    opt.setOrder(3);
                    nameList.addOption(opt);
                    exclusions.add(s);
                }
            }
        } else if (SHARE_DOCUMENT.equals(typeOfRelation)) {
            if (name != null && name.contains(",")) {
                String[] items;
                for (String item : items = name.split(",")) {
                    IdentityNameList.Option opt = new IdentityNameList.Option();
                    if (item.startsWith(SPACE_PREFIX)) {
                        Space s = this.getSpaceService().getSpaceByPrettyName(item.substring(7));
                        opt.setType("space");
                        opt.setValue(SPACE_PREFIX + s.getPrettyName());
                        opt.setText(s.getDisplayName());
                        opt.setAvatarUrl(s.getAvatarUrl());
                        opt.setOrder(2);
                    } else {
                        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", item, false);
                        opt.setType("user");
                        opt.setOrder(1);
                        if (identity != null) {
                            Profile profile = identity.getProfile();
                            opt.setValue((String)profile.getProperty("username"));
                            opt.setText(profile.getFullName());
                            opt.setAvatarUrl(profile.getAvatarUrl());
                        } else {
                            opt.setValue(item);
                            opt.setText(item);
                            opt.setInvalid(true);
                        }
                    }
                    nameList.addOption(opt);
                }
                return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
            }
            ListAccess connections = this.getRelationshipManager().getConnectionsByFilter(currentIdentity, identityFilter);
            if (connections != null && connections.getSize() > 0) {
                Identity[] identities;
                int size = connections.getSize();
                for (Identity id : identities = (Identity[])connections.load(0, (long)size < 20L ? size : 20)) {
                    IdentityNameList.Option option = new IdentityNameList.Option();
                    String fullName = id.getProfile().getFullName();
                    String userName = (String)id.getProfile().getProperty("username");
                    option.setType("user");
                    option.setValue(userName);
                    option.setText(fullName + " (" + userName + ")");
                    option.setAvatarUrl(id.getProfile() == null ? null : id.getProfile().getAvatarUrl());
                    excludedIdentityList.add(id);
                    option.setOrder(1);
                    nameList.addOption(option);
                }
            }
            ArrayList<Space> exclusions = new ArrayList<Space>();
            long remain = 20L - (long)(nameList.getOptions() != null ? nameList.getOptions().size() : 0);
            if (remain > 0L) {
                Space[] spaces;
                SpaceFilter spaceFilter = new SpaceFilter();
                spaceFilter.setSpaceNameSearchCondition(name);
                ListAccess list = this.getSpaceService().getMemberSpacesByFilter(currentUser, spaceFilter);
                for (Space s : spaces = (Space[])list.load(0, (int)remain)) {
                    IdentityNameList.Option opt = new IdentityNameList.Option();
                    opt.setType("space");
                    opt.setValue(SPACE_PREFIX + s.getPrettyName());
                    opt.setText(s.getDisplayName());
                    opt.setAvatarUrl(s.getAvatarUrl());
                    opt.setOrder(2);
                    nameList.addOption(opt);
                    exclusions.add(s);
                }
            }
            if ((remain = 20L - (long)(nameList.getOptions() != null ? nameList.getOptions().size() : 0)) > 0L) {
                identityFilter.setExcludedIdentityList(excludedIdentityList);
                ListAccess listAccess = this.getIdentityManager().getIdentitiesByProfileFilter("organization", identityFilter, false);
                List<Object> identities = Arrays.asList(listAccess.load(0, (int)remain));
                for (Identity identity : identities) {
                    IdentityNameList.Option opt = new IdentityNameList.Option();
                    String fullName = identity.getProfile().getFullName();
                    String userName = (String)identity.getProfile().getProperty("username");
                    opt.setType("user");
                    opt.setValue(userName);
                    opt.setText(fullName);
                    opt.setAvatarUrl(identity.getProfile() == null ? null : identity.getProfile().getAvatarUrl());
                    excludedIdentityList.add(identity);
                    opt.setOrder(4);
                    nameList.addOption(opt);
                }
            }
        } else {
            if (MENTION_ACTIVITY_STREAM.equals(typeOfRelation)) {
                long remain;
                LinkedHashSet<UserInfo> userInfos = new LinkedHashSet<UserInfo>();
                if (currentSpace != null) {
                    userInfos = this.addSpaceMembers(spaceURL, identityFilter, userInfos, currentUser);
                }
                if ((remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                    userInfos = this.addUserConnections(currentIdentity, identityFilter, userInfos, currentUser, remain);
                }
                if ((remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                    userInfos = this.addOtherUsers(identityFilter, excludedIdentityList, userInfos, currentUser, remain);
                }
                return Util.getResponse(userInfos, uriInfo, mediaType, Response.Status.OK);
            }
            if (MENTION_COMMENT.equals(typeOfRelation)) {
                LinkedHashSet<UserInfo> userInfos = new LinkedHashSet<UserInfo>();
                long remain = 20L;
                if (activityId == null) {
                    LOG.warn((Object)"Mentioning in activity comment : activity id parameter is null. the activity users will not be added in the result of mentioning.");
                } else {
                    ExoSocialActivity activity = this.getActivityManager().getActivity(activityId);
                    String authorId = activity.getPosterId();
                    userInfos = this.addUsernameToInfosList(authorId, identityFilter, userInfos, currentUser, true);
                    remain = 20L - (long)((userInfos = this.addCommentedUsers(activity, identityFilter, excludedIdentityList, userInfos, currentUser)) != null ? userInfos.size() : 0);
                    if (remain > 0L) {
                        userInfos = this.addMentionedUsers(activity, identityFilter, excludedIdentityList, userInfos, currentUser);
                    }
                    if ((remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                        userInfos = this.addLikedUsers(activity, identityFilter, excludedIdentityList, userInfos, currentUser);
                    }
                }
                if (currentSpace != null && currentActivity != null && (remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                    userInfos = this.addSpaceMembers(spaceURL, identityFilter, userInfos, currentUser);
                }
                if ((remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                    userInfos = this.addUserConnections(currentIdentity, identityFilter, userInfos, currentUser, remain);
                }
                if ((remain = 20L - (long)(userInfos != null ? userInfos.size() : 0)) > 0L) {
                    userInfos = this.addOtherUsers(identityFilter, excludedIdentityList, userInfos, currentUser, remain);
                }
                return Util.getResponse(userInfos, uriInfo, mediaType, Response.Status.OK);
            }
            Identity[] result = this.getIdentityManager().getIdentityStorage().getIdentitiesForMentions("organization", identityFilter, null, 0L, 20L, false).toArray(new Identity[0]);
            nameList.addToNameList(result);
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private LinkedHashSet<UserInfo> addUsersToUserInfosList(Identity[] identities, ProfileFilter identityFilter, LinkedHashSet<UserInfo> userInfos, String currentUserId, boolean filterByName) {
        for (Identity identity : identities) {
            userInfos = this.addUserToInfosList(identity, identityFilter, userInfos, currentUserId, filterByName);
        }
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addUserToInfosList(Identity userIdentity, ProfileFilter identityFilter, LinkedHashSet<UserInfo> userInfos, String currentUserId, boolean filterByName) {
        if (!userIdentity.getProviderId().equals("organization")) {
            LOG.warn((Object)("Cannot add Identity to suggestion list. Identity with id '" + userIdentity.getRemoteId() + "' is not of type 'user'"));
            return userInfos;
        }
        if ((long)userInfos.size() == 20L) {
            return userInfos;
        }
        if (identityFilter.getExcludedIdentityList().contains(userIdentity)) {
            return userInfos;
        }
        if (filterByName && !userIdentity.getRemoteId().toLowerCase().contains(identityFilter.getName().toLowerCase()) && !userIdentity.getProfile().getFullName().toLowerCase().contains(identityFilter.getName().toLowerCase())) {
            return userInfos;
        }
        UserInfo user = new UserInfo();
        boolean isAnonymous = IdentityConstants.ANONIM.equals(currentUserId);
        if (!isAnonymous) {
            user.setId(userIdentity.getRemoteId());
        }
        user.setName(userIdentity.getProfile() == null ? null : userIdentity.getProfile().getFullName());
        user.setAvatar(userIdentity.getProfile() == null ? null : userIdentity.getProfile().getAvatarUrl());
        user.setType("contact");
        userInfos.add(user);
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addUsernameToInfosList(String userId, ProfileFilter identityFilter, LinkedHashSet<UserInfo> userInfos, String currentUserId, boolean filterByName) {
        Identity userIdentity = this.getIdentityManager().getIdentity(userId, false);
        if (userIdentity == null) {
            userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", userId, false);
        }
        if (userIdentity == null) {
            LOG.warn((Object)("Cannot find user identity with username = " + userId));
            return userInfos;
        }
        return this.addUserToInfosList(userIdentity, identityFilter, userInfos, currentUserId, filterByName);
    }

    private LinkedHashSet<UserInfo> addUserConnections(Identity currentIdentity, ProfileFilter identityFilter, LinkedHashSet<UserInfo> userInfos, String currentUser, long remain) throws Exception {
        ListAccess connections = this.getRelationshipManager().getConnectionsByFilter(currentIdentity, identityFilter);
        if (connections != null && connections.getSize() > 0) {
            Identity[] identities = (Identity[])connections.load(0, (int)remain);
            userInfos = this.addUsersToUserInfosList(identities, identityFilter, userInfos, currentUser, false);
        }
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addOtherUsers(ProfileFilter identityFilter, List<Identity> excludedIdentityList, LinkedHashSet<UserInfo> userInfos, String currentUser, long remain) throws Exception {
        List listAccess = this.getIdentityManager().getIdentityStorage().getIdentitiesForMentions("organization", identityFilter, null, 0L, remain, false);
        identityFilter.setExcludedIdentityList(excludedIdentityList);
        Identity[] identitiesList = listAccess.toArray(new Identity[0]);
        userInfos = this.addUsersToUserInfosList(identitiesList, identityFilter, userInfos, currentUser, false);
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addSpaceMembers(String spaceURL, ProfileFilter identityFilter, LinkedHashSet<UserInfo> userInfos, String currentUser) {
        String[] spaceMembers;
        for (String spaceMember : spaceMembers = this.getSpaceService().getSpaceByUrl(spaceURL).getMembers()) {
            userInfos = this.addUsernameToInfosList(spaceMember, identityFilter, userInfos, currentUser, true);
        }
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addCommentedUsers(ExoSocialActivity activity, ProfileFilter identityFilter, List<Identity> excludedIdentityList, LinkedHashSet<UserInfo> userInfos, String currentUser) {
        String[] commentedUsers;
        for (String commentedUser : commentedUsers = activity.getCommentedIds()) {
            identityFilter.setExcludedIdentityList(excludedIdentityList);
            userInfos = this.addUsernameToInfosList(commentedUser, identityFilter, userInfos, currentUser, true);
        }
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addMentionedUsers(ExoSocialActivity activity, ProfileFilter identityFilter, List<Identity> excludedIdentityList, LinkedHashSet<UserInfo> userInfos, String currentUser) {
        String[] mentionedUsers;
        for (String mentionedUser : mentionedUsers = activity.getMentionedIds()) {
            identityFilter.setExcludedIdentityList(excludedIdentityList);
            userInfos = this.addUsernameToInfosList(mentionedUser, identityFilter, userInfos, currentUser, true);
        }
        return userInfos;
    }

    private LinkedHashSet<UserInfo> addLikedUsers(ExoSocialActivity activity, ProfileFilter identityFilter, List<Identity> excludedIdentityList, LinkedHashSet<UserInfo> userInfos, String currentUser) {
        String[] likedUsers;
        for (String likedUser : likedUsers = activity.getLikeIdentityIds()) {
            identityFilter.setExcludedIdentityList(excludedIdentityList);
            userInfos = this.addUsernameToInfosList(likedUser, identityFilter, userInfos, currentUser, true);
        }
        return userInfos;
    }

    private void addSpaceOrUserToList(List<Identity> identities, IdentityNameList options, Space space, String typeOfRelation, int order) throws SpaceException {
        SpaceService spaceSrv = this.getSpaceService();
        for (Identity identity : identities) {
            String fullName = identity.getProfile().getFullName();
            String userName = (String)identity.getProfile().getProperty("username");
            IdentityNameList.Option opt = new IdentityNameList.Option();
            if (SPACE_MEMBER.equals(typeOfRelation) && spaceSrv.isMember(space, userName)) {
                opt.setType("user");
                opt.setValue(fullName);
                opt.setText(fullName);
                opt.setAvatarUrl(identity.getProfile() == null ? null : identity.getProfile().getAvatarUrl());
            } else {
                if (!USER_TO_INVITE.equals(typeOfRelation) || space != null && (spaceSrv.isInvitedUser(space, userName) || spaceSrv.isPendingUser(space, userName) || spaceSrv.isMember(space, userName))) continue;
                opt.setType("user");
                opt.setValue(userName);
                opt.setText(fullName + " (" + userName + ")");
                opt.setAvatarUrl(identity.getProfile() == null ? null : identity.getProfile().getAvatarUrl());
            }
            opt.setOrder(order);
            options.addOption(opt);
        }
    }

    @GET
    @Path(value="getprofile/data.json")
    @RolesAllowed(value={"users"})
    public Response suggestUsernames(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @QueryParam(value="search") String query) throws Exception {
        MediaType mediaType = Util.getMediaType("json", new String[]{"json"});
        ProfileFilter filter = new ProfileFilter();
        filter.setName(query);
        List<Object> identities = Arrays.asList(this.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, false).load(0, 20));
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>(identities.size());
        String userType = ConversationState.getCurrent().getIdentity().getUserId();
        boolean isAnonymous = IdentityConstants.ANONIM.equals(userType) || securityContext.getUserPrincipal() == null;
        for (Identity identity : identities) {
            UserInfo userInfo = new UserInfo();
            if (!isAnonymous) {
                userInfo.setId(identity.getRemoteId());
            }
            userInfo.setName(identity.getProfile().getFullName());
            userInfo.setAvatar(identity.getProfile() == null ? null : identity.getProfile().getAvatarUrl());
            userInfo.setType("contact");
            userInfos.add(userInfo);
        }
        return Util.getResponse(userInfos, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{portalName}/getConnections.{format}")
    @RolesAllowed(value={"users"})
    public Response searchConnection(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="portalName") String portalName, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="lang") String lang, @PathParam(value="format") String format) throws Exception {
        Identity[] identities;
        String[] supportedMediaType = new String[]{"json"};
        MediaType mediaType = Util.getMediaType(format, supportedMediaType);
        this.activityManager = Util.getActivityManager(portalName);
        this.relationshipManager = Util.getRelationshipManager(portalName);
        this.identityManager = Util.getIdentityManager(portalName);
        Identity currentUser = Util.getIdentityManager(portalName).getOrCreateIdentity("organization", Util.getViewerId(), true);
        ArrayList<HashMap<String, Object>> entitys = new ArrayList<HashMap<String, Object>>();
        if (nameToSearch == null) {
            identities = (Identity[])this.getIdentityManager().getConnectionsWithListAccess(currentUser).load(offset, limit);
        } else {
            nameToSearch = nameToSearch.trim();
            ProfileFilter filter = new ProfileFilter();
            filter.setName(nameToSearch);
            filter.setViewerIdentity(currentUser);
            identities = (Identity[])this.relationshipManager.getConnectionsByFilter(currentUser, filter).load(offset, limit);
        }
        String userType = ConversationState.getCurrent().getIdentity().getUserId();
        boolean isAnonymous = IdentityConstants.ANONIM.equals(userType) || securityContext.getUserPrincipal() == null;
        for (Identity identity : identities) {
            if (isAnonymous) {
                entitys.add(new ConnectionInfoRestOut(identity));
                continue;
            }
            HashMap<String, Object> temp = this.getIdentityInfo(identity, lang);
            if (temp == null) continue;
            entitys.add(temp);
        }
        return Util.getResponse(entitys, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="/getPeopleInfo/{userId}.{format}")
    @RolesAllowed(value={"users"})
    public Response getPeopleInfo(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="userId") String userId, @PathParam(value="format") String format, @QueryParam(value="currentUserName") String currentUserName, @QueryParam(value="updatedType") String updatedType) throws Exception {
        Object[] mediaTypes;
        if (format.indexOf(46) > 0) {
            userId = new StringBuffer(userId).append(".").append(format.substring(0, format.lastIndexOf(46))).toString();
            format = format.substring(format.lastIndexOf(46) + 1);
        }
        String string = format = ArrayUtils.contains((Object[])(mediaTypes = new String[]{"json", "xml"}), (Object)format) ? format : mediaTypes[0];
        if (currentUserName == null || currentUserName.trim().isEmpty()) {
            currentUserName = this.getUserId(securityContext, uriInfo);
        }
        MediaType mediaType = Util.getMediaType(format, (String[])mediaTypes);
        PeopleInfo peopleInfo = new PeopleInfo(NO_INFO);
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", userId);
        Identity currentIdentity = this.getIdentityManager().getOrCreateIdentity("organization", currentUserName);
        if (identity != null) {
            boolean isAnonymous;
            peopleInfo.setFullName(identity.getProfile().getFullName());
            peopleInfo.setPosition(StringEscapeUtils.unescapeHtml((String)identity.getProfile().getPosition()));
            peopleInfo.setDeleted(identity.isDeleted());
            peopleInfo.setEnable(identity.isEnable());
            Profile userProfile = identity.getProfile();
            String avatarURL = userProfile.getAvatarUrl();
            if (avatarURL == null) {
                avatarURL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
            }
            peopleInfo.setAvatarURL(avatarURL);
            String userType = ConversationState.getCurrent().getIdentity().getUserId();
            boolean bl = isAnonymous = IdentityConstants.ANONIM.equals(userType) || securityContext.getUserPrincipal() == null || !userType.equals(currentIdentity.getRemoteId());
            if (!isAnonymous) {
                String activityTitle;
                peopleInfo.setProfileUrl(LinkProvider.getProfileUri((String)identity.getRemoteId()));
                peopleInfo.setRelationshipType(NO_ACTION);
                String relationshipType = null;
                if (currentUserName != null && !userId.equals(currentUserName)) {
                    Relationship relationship = this.getRelationshipManager().get(currentIdentity, identity);
                    if (currentIdentity != null) {
                        if (updatedType != null && currentIdentity != null) {
                            if (ACCEPT_ACTION.equals(updatedType)) {
                                this.getRelationshipManager().confirm(currentIdentity, identity);
                            } else if (DENY_ACTION.equals(updatedType)) {
                                this.getRelationshipManager().deny(currentIdentity, identity);
                            } else if (REVOKE_ACTION.equals(updatedType)) {
                                this.getRelationshipManager().deny(currentIdentity, identity);
                            } else if (INVITE_ACTION.equals(updatedType)) {
                                this.getRelationshipManager().inviteToConnect(currentIdentity, identity);
                            } else if (REMOVE_ACTION.equals(updatedType)) {
                                this.getRelationshipManager().delete(this.getRelationshipManager().get(currentIdentity, identity));
                            }
                            relationship = this.getRelationshipManager().get(currentIdentity, identity);
                        }
                        relationshipType = this.getRelationshipType(relationship, currentIdentity);
                        peopleInfo.setRelationshipType(relationshipType);
                    }
                }
                if (CONFIRMED_STATUS.equals(relationshipType) && (activityTitle = this.getLatestActivityTitle(identity, currentIdentity)) != null) {
                    peopleInfo.setActivityTitle(StringEscapeUtils.unescapeHtml((String)activityTitle));
                }
            }
        }
        return Util.getResponse(peopleInfo, uriInfo, mediaType, Response.Status.OK);
    }

    private String getUserId(SecurityContext securityContext, UriInfo uriInfo) {
        String userId = "";
        try {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not get id of user from ConversationState.");
        }
        if ((userId == null || userId.isEmpty() || IdentityConstants.ANONIM.equals(userId)) && securityContext != null && securityContext.getUserPrincipal() != null) {
            return securityContext.getUserPrincipal().getName();
        }
        return userId;
    }

    private HashMap<String, Object> getIdentityInfo(Identity existingIdentity, String lang) {
        RealtimeListAccess activityRealtimeListAccess = this.activityManager.getActivitiesWithListAccess(existingIdentity);
        if (activityRealtimeListAccess.getSize() == 0) {
            return null;
        }
        ExoSocialActivity lastestActivity = ((ExoSocialActivity[])activityRealtimeListAccess.load(0, 1))[0];
        return new ConnectionInfoRestOut(existingIdentity, lastestActivity, lang);
    }

    private String getRelationshipType(Relationship relationship, Identity identity) {
        if (relationship == null) {
            return ALIEN_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.PENDING) {
            if (relationship.getSender().equals((Object)identity)) {
                return WAITING_STATUS;
            }
            return PENDING_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.CONFIRMED) {
            return CONFIRMED_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.IGNORED) {
            return IGNORED_STATUS;
        }
        return ALIEN_STATUS;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getPortalContainer().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.getPortalContainer().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.getPortalContainer().getComponentInstanceOfType(ActivityManager.class);
        }
        return this.activityManager;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)this.getPortalContainer().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private ExoContainer getPortalContainer() {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        if (exoContainer == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return exoContainer;
    }

    private String getLatestActivityTitle(Identity identity, Identity currentIdentity) {
        RealtimeListAccess activitiesListAccess = this.getActivityManager().getActivitiesByPoster(identity, new String[]{DEFAULT_ACTIVITY, LINK_ACTIVITY, DOC_ACTIVITY});
        int totalActivities = activitiesListAccess.getSize();
        int loadedActivityNum = 0;
        do {
            List activities = activitiesListAccess.loadAsList(0, 20);
            loadedActivityNum += activities.size();
            for (ExoSocialActivity act : activities) {
                if (this.getIdentityManager().getOrCreateIdentity("organization", act.getStreamOwner(), false) != null) {
                    return act.getTitle();
                }
                if (this.getIdentityManager().getOrCreateIdentity("space", act.getStreamOwner(), false) == null) continue;
                Space space = this.getSpaceService().getSpaceByPrettyName(act.getStreamOwner());
                if (!this.getSpaceService().isMember(space, currentIdentity.getRemoteId())) continue;
                return act.getTitle();
            }
        } while (loadedActivityNum < totalActivities);
        return null;
    }

    public static class UserInfo {
        private static String AVATAR_URL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
        String id;
        String name;
        String avatar;
        String type;

        public void setId(String id) {
            this.id = "@" + id;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAvatar(String url) {
            this.avatar = url;
        }

        public String getAvatar() {
            if (this.avatar == null || this.avatar.length() == 0) {
                return AVATAR_URL;
            }
            return this.avatar;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof UserInfo)) {
                return false;
            }
            return this.id.equals(((UserInfo)obj).getId());
        }
    }

    public static class ConnectionInfoRestOut
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -3638967656497819786L;

        public ConnectionInfoRestOut() {
            this.initialize();
        }

        public ConnectionInfoRestOut(Identity identity) {
            this.setDisplayName(identity.getProfile().getFullName());
            this.setAvatarUrl(Util.buildAbsoluteAvatarURL(identity));
            this.setPosition(StringEscapeUtils.unescapeHtml((String)identity.getProfile().getPosition()));
        }

        public ConnectionInfoRestOut(Identity identity, ExoSocialActivity lastestActivity, String lang) {
            this.setDisplayName(identity.getProfile().getFullName());
            this.setAvatarUrl(Util.buildAbsoluteAvatarURL(identity));
            this.setProfileUrl(identity.getProfile().getUrl());
            this.setActivityTitle(lastestActivity.getTitle());
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            int gmtoffset = calendar.get(16) + calendar.get(15);
            calendar.setTimeInMillis(lastestActivity.getPostedTime() - (long)gmtoffset);
            this.setPrettyPostedTime(TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)"EEE,MMM dd,yyyy", (Locale)new Locale(lang), (int)TimeConvertUtils.MONTH));
            this.setPosition(StringEscapeUtils.unescapeHtml((String)identity.getProfile().getPosition()));
            this.setActivityId(lastestActivity.getId());
        }

        public String getDisplayName() {
            return (String)this.get(Field.DISPLAY_NAME.toString());
        }

        public void setDisplayName(String displayName) {
            if (displayName != null) {
                this.put(Field.DISPLAY_NAME.toString(), displayName);
            } else {
                this.put(Field.DISPLAY_NAME.toString(), "");
            }
        }

        public String getAvatarUrl() {
            return (String)this.get(Field.AVATAR_URL.toString());
        }

        public void setAvatarUrl(String avatarUrl) {
            if (avatarUrl != null) {
                this.put(Field.AVATAR_URL.toString(), avatarUrl);
            } else {
                this.put(Field.AVATAR_URL.toString(), "");
            }
        }

        public String getProfileUrl() {
            return (String)this.get(Field.PROFILE_URL.toString());
        }

        public void setProfileUrl(String profileUrl) {
            if (profileUrl != null) {
                this.put(Field.PROFILE_URL.toString(), Util.getBaseUrl() + profileUrl);
            } else {
                this.put(Field.PROFILE_URL.toString(), "");
            }
        }

        public String getActivityTitle() {
            return (String)this.get(Field.ACTIVITY_TITLE.toString());
        }

        public void setActivityTitle(String activityTitle) {
            if (activityTitle != null) {
                this.put(Field.ACTIVITY_TITLE.toString(), activityTitle);
            } else {
                this.put(Field.ACTIVITY_TITLE.toString(), "");
            }
        }

        public String getPrettyPostedTime() {
            return (String)this.get((Object)Field.PRETTY_POSTED_TIME);
        }

        public void setPrettyPostedTime(String postedTime) {
            if (postedTime != null) {
                this.put(Field.PRETTY_POSTED_TIME.toString(), postedTime);
            } else {
                this.put(Field.PRETTY_POSTED_TIME.toString(), new Long(0L));
            }
        }

        public String getPosition() {
            return (String)this.get((Object)Field.POSITION);
        }

        public void setPosition(String position) {
            if (position != null) {
                this.put(Field.POSITION.toString(), position);
            } else {
                this.put(Field.POSITION.toString(), "");
            }
        }

        public String getActivityId() {
            return (String)this.get((Object)Field.ACTIVITY_ID);
        }

        public void setActivityId(String activityId) {
            if (activityId != null) {
                this.put(Field.ACTIVITY_ID.toString(), activityId);
            } else {
                this.put(Field.ACTIVITY_ID.toString(), "");
            }
        }

        private void initialize() {
            this.setActivityTitle("");
            this.setAvatarUrl("");
            this.setDisplayName("");
            this.setProfileUrl("");
            this.setActivityId("");
            this.setPosition("");
            this.setPrettyPostedTime("");
        }

        public static enum Field {
            DISPLAY_NAME("displayName"),
            AVATAR_URL("avatarURL"),
            PROFILE_URL("profileURL"),
            ACTIVITY_TITLE("activityTitle"),
            ACTIVITY_ID("activityId"),
            PRETTY_POSTED_TIME("prettyPostedTime"),
            POSITION("position");

            private final String fieldName;

            private Field(String string2) {
                this.fieldName = string2;
            }

            public String toString() {
                return this.fieldName;
            }
        }
    }
}

