/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.service.rest.api.VersionResources;
import org.exoplatform.social.service.rest.api.models.Versions;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class VersionResourcesTest
extends AbstractResourceTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.addResource(VersionResources.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        this.removeResource(VersionResources.class);
        super.tearDown();
    }

    public void testGetLatestVersionWithJsonFormat() throws Exception {
        ContainerResponse containerResponse = this.service("GET", "/api/social/version/latest.json", "", null, null);
        VersionResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        VersionResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse.getStatus());
        Object entity = containerResponse.getEntity();
        VersionResourcesTest.assertNotNull((String)"entity must not be null", (Object)entity);
        String expectedResponse = "{\"version\":\"v1-alpha3\"}";
        this.assertJsonStringEqualsEntity("{\"version\":\"v1-alpha3\"}", entity);
    }

    public void testGetLatestVersionWithXmlFormat() throws Exception {
        ContainerResponse containerResponse = this.service("GET", "/api/social/version/latest.xml", "", null, null);
        VersionResourcesTest.assertEquals((int)415, (int)containerResponse.getStatus());
    }

    public void testGetSupportedVersionsWithJsonFormat() throws Exception {
        ContainerResponse containerResponse = this.service("GET", "/api/social/version/supported.json", "", null, null);
        VersionResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        VersionResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse.getStatus());
        Object entity = containerResponse.getEntity();
        VersionResourcesTest.assertNotNull((String)"entity must not be null", (Object)entity);
        String expectedResponse = "{\"versions\": [\"v1-alpha3\",\"v1\"]}";
        this.assertJsonStringEqualsEntity("{\"versions\": [\"v1-alpha3\",\"v1\"]}", entity);
    }

    public void testGetSupportedVersionsWithXmlFormat() throws Exception {
        ContainerResponse containerResponse = this.service("GET", "/api/social/version/supported.xml", "", null, null);
        VersionResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse.getContentType().toString().startsWith("application/xml".toString()));
        VersionResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse.getStatus());
        Versions entity = (Versions)containerResponse.getEntity();
        VersionResourcesTest.assertNotNull((String)"entity must not be null", (Object)entity);
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><versions><version>v1-alpha3</version></versions>";
        this.assertXmlStringEqualsEntity("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><versions><version>v1-alpha3</version></versions>", entity);
    }
}

